/*
 * Decompiled with CFR 0.152.
 */
package com.mirre.random.utils.enums;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Furnace;

public enum BlockFeature {
    BREWINGTIME(0){

        @Override
        public void set(Block block, Number value) {
            if (block.getType() != Material.BREWING_STAND) {
                return;
            }
            BrewingStand stand = (BrewingStand)block.getState();
            stand.setBrewingTime(value.intValue());
            stand.update(true);
        }

        @Override
        public Number get(Block block) {
            if (block.getType() != Material.BREWING_STAND) {
                return null;
            }
            BrewingStand stand = (BrewingStand)block.getState();
            return stand.getBrewingTime();
        }
    }
    ,
    BURNTIME(1){

        @Override
        public void set(Block block, Number value) {
            if (block.getType() != Material.FURNACE && block.getType() != Material.BURNING_FURNACE) {
                return;
            }
            Furnace furnace = (Furnace)block.getState();
            furnace.setBurnTime(value.shortValue());
            furnace.update(true);
        }

        @Override
        public Number get(Block block) {
            if (block.getType() != Material.FURNACE && block.getType() != Material.BURNING_FURNACE) {
                return null;
            }
            Furnace furnace = (Furnace)block.getState();
            return furnace.getBurnTime();
        }
    }
    ,
    COOKTIME(2){

        @Override
        public void set(Block block, Number value) {
            if (block.getType() != Material.FURNACE && block.getType() != Material.BURNING_FURNACE) {
                return;
            }
            Furnace furnace = (Furnace)block.getState();
            furnace.setCookTime(value.shortValue());
            furnace.update(true);
        }

        @Override
        public Number get(Block block) {
            if (block.getType() != Material.FURNACE && block.getType() != Material.BURNING_FURNACE) {
                return null;
            }
            Furnace furnace = (Furnace)block.getState();
            return furnace.getCookTime();
        }
    }
    ,
    SPAWNDELAY(3){

        @Override
        public void set(Block block, Number value) {
            if (block.getType() != Material.MOB_SPAWNER) {
                return;
            }
            CreatureSpawner spawner = (CreatureSpawner)block.getState();
            spawner.setDelay(value.intValue());
            spawner.update(true);
        }

        @Override
        public Number get(Block block) {
            if (block.getType() != Material.MOB_SPAWNER) {
                return null;
            }
            CreatureSpawner spawner = (CreatureSpawner)block.getState();
            return spawner.getDelay();
        }
    };

    private int parseMark;

    private BlockFeature(int mark) {
        this.parseMark = mark;
    }

    public abstract void set(Block var1, Number var2);

    public abstract Number get(Block var1);

    public static BlockFeature getBlockFeature(int mark) {
        BlockFeature[] blockFeatureArray = BlockFeature.values();
        int n = blockFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFeature bf = blockFeatureArray[n2];
            if (mark == bf.getMark()) {
                return bf;
            }
            ++n2;
        }
        return null;
    }

    public int getMark() {
        return this.parseMark;
    }

    /* synthetic */ BlockFeature(String string, int n, int n2, BlockFeature blockFeature) {
        this(n2);
    }
}

