/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.utils.reflection.helpers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.mirreski.random.utils.reflection.ClassGetter;

public class HelperManager {
    private Map<String, Class<?>> classes = new HashMap();
    private Map<String, Method> methods = new HashMap<String, Method>();
    private Map<String, Field> fields = new HashMap<String, Field>();
    private Map<String, Constructor<?>> constructors = new HashMap();
    private static HelperManager INSTANCE = null;

    public Map<String, Class<?>> getClasses() {
        return this.classes;
    }

    public void addToClasses(String key, Class<?> c) {
        if (!this.classes.containsKey(key)) {
            this.classes.put(key, c);
        }
    }

    public Map<String, Method> getMethods() {
        return this.methods;
    }

    public void addToMethods(String key, Method m) {
        if (!this.methods.containsKey(key)) {
            this.methods.put(key, m);
        }
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public void addToFields(String key, Field f) {
        if (!this.fields.containsKey(key)) {
            this.fields.put(key, f);
        }
    }

    public Map<String, Constructor<?>> getConstructors() {
        return this.constructors;
    }

    public void addToConstructors(String key, Constructor<?> c) {
        if (!this.constructors.containsKey(key)) {
            this.constructors.put(key, c);
        }
    }

    public static HelperManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HelperManager();
        }
        return INSTANCE;
    }

    public Object invokeMethod(Object target, String className, String methodName, String[] parameters, Object ... args) {
        ArrayList classList = new ArrayList();
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            classList.add(this.fetchClass(s));
            ++n2;
        }
        return this.invokeMethod(target, className, methodName, classList.toArray(new Class[classList.size()]), args);
    }

    public Object invokeMethod(Object target, String className, String methodName) {
        Method m = this.fetchMethod(className, methodName, new Class[]{null});
        boolean b = m.isAccessible();
        if (!b) {
            m.setAccessible(true);
        }
        Object o = null;
        if (m != null) {
            try {
                o = m.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!b) {
            m.setAccessible(false);
        }
        return o;
    }

    public Object invokeMethod(Object target, String className, String methodName, Class<?>[] parameters, Object ... args) {
        Method m = this.fetchMethod(className, methodName, parameters);
        boolean b = m.isAccessible();
        if (!b) {
            m.setAccessible(true);
        }
        Object o = null;
        if (m != null) {
            try {
                o = m.invoke(target, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!b) {
            m.setAccessible(false);
        }
        return o;
    }

    public Object getFromField(Object target, String className, String fieldName) {
        Field f = this.fetchField(className, fieldName);
        boolean b = f.isAccessible();
        if (!b) {
            f.setAccessible(true);
        }
        Object o = null;
        if (f != null) {
            try {
                o = f.get(target);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!b) {
            f.setAccessible(false);
        }
        return o;
    }

    public void setField(Object target, String className, String fieldName, Object value) {
        Field f = this.fetchField(className, fieldName);
        boolean b = f.isAccessible();
        if (!b) {
            f.setAccessible(true);
        }
        if (f != null) {
            try {
                f.set(target, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!b) {
            f.setAccessible(false);
        }
    }

    public Object constructObject(String className, String[] parameters, Object ... args) {
        ArrayList classList = new ArrayList();
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            classList.add(this.fetchClass(s));
            ++n2;
        }
        return this.constructObject(className, classList.toArray(new Class[classList.size()]), args);
    }

    public Object constructObject(String className, Class<?>[] parameters, Object ... args) {
        Constructor<?> c = this.fetchClassConstructor(className, parameters);
        boolean b = c.isAccessible();
        if (!b) {
            c.setAccessible(true);
        }
        Object o = null;
        if (c != null) {
            try {
                o = args.length == 0 ? c.newInstance(new Object[0]) : c.newInstance(args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!b) {
            c.setAccessible(false);
        }
        return o;
    }

    public Object constructObject(String className, Object ... args) {
        Constructor<?> c = this.fetchNonNullConstructor(className);
        if (c == null) {
            return null;
        }
        boolean b = c.isAccessible();
        if (!b) {
            c.setAccessible(true);
        }
        Object o = null;
        try {
            o = args.length == 0 ? c.newInstance(new Object[0]) : c.newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!b) {
            c.setAccessible(false);
        }
        return o;
    }

    public Object constructObject(String className) {
        Constructor<?> c = this.fetchClassConstructor(className, new Class[0]);
        boolean b = c.isAccessible();
        if (!b) {
            c.setAccessible(true);
        }
        Object o = null;
        if (c != null) {
            try {
                o = c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!b) {
            c.setAccessible(false);
        }
        return o;
    }

    public Class<?> fetchClass(String className) {
        if (this.getClasses().containsKey(className)) {
            return this.getClasses().get(className);
        }
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (c != null) {
            this.addToClasses(className, c);
        }
        return c;
    }

    public Method fetchMethod(String className, String methodName, String ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return this.fetchMethod(className, methodName, new Class[]{null});
        }
        ArrayList classList = new ArrayList();
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            classList.add(this.fetchClass(s));
            ++n2;
        }
        return this.fetchMethod(className, methodName, classList.toArray(new Class[classList.size()]));
    }

    public Method fetchMethod(String className, String methodName, Class<?> ... parameters) {
        String key = String.valueOf(className) + "." + methodName + "()";
        if ((parameters.length != 0 || parameters.length == 1) && parameters[0] != null) {
            key = String.valueOf(className) + "." + methodName + "(" + this.collectClassNames(parameters) + ")";
        }
        if (this.getMethods().containsKey(key)) {
            return this.getMethods().get(key);
        }
        Class<?> c = this.fetchClass(className);
        if (c == null) {
            return null;
        }
        Method m = null;
        try {
            m = (parameters.length != 0 || parameters.length == 1) && parameters[0] != null ? c.getDeclaredMethod(methodName, parameters) : c.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (m != null) {
            this.addToMethods(key, m);
        }
        return m;
    }

    public Field fetchField(String className, String fieldName) {
        String key = String.valueOf(className) + ":" + fieldName;
        if (this.getFields().containsKey(key)) {
            return this.getFields().get(key);
        }
        Class<?> c = this.fetchClass(className);
        if (c == null) {
            return null;
        }
        Field f = null;
        try {
            f = c.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (f != null) {
            this.addToFields(key, f);
        }
        return f;
    }

    public Constructor<?> fetchConstructor(String className, String ... parameters) {
        ArrayList classList = new ArrayList();
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            classList.add(this.fetchClass(s));
            ++n2;
        }
        return this.fetchClassConstructor(className, classList.toArray(new Class[classList.size()]));
    }

    public Constructor<?> fetchNonNullConstructor(String className) {
        String key = String.valueOf(className) + ";" + "nonnull";
        if (this.getConstructors().containsKey(key)) {
            return this.getConstructors().get(key);
        }
        Class<?> c = this.fetchClass(className);
        if (c == null) {
            return null;
        }
        Constructor<?> cn = null;
        try {
            cn = ClassGetter.getConstructor(c);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (cn != null) {
            this.addToConstructors(key, cn);
        }
        return cn;
    }

    public Constructor<?> fetchClassConstructor(String className, Class<?> ... parameters) {
        String key = String.valueOf(className) + ";" + "empty";
        if (parameters.length != 0) {
            key = String.valueOf(className) + ";" + this.collectClassNames(parameters);
        }
        if (this.getConstructors().containsKey(key)) {
            return this.getConstructors().get(key);
        }
        Class<?> c = this.fetchClass(className);
        if (c == null) {
            return null;
        }
        Constructor<?> cn = null;
        try {
            cn = parameters.length != 0 ? c.getDeclaredConstructor(parameters) : c.getDeclaredConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (cn != null) {
            this.addToConstructors(key, cn);
        }
        return cn;
    }

    public String collectClassNames(Class<?> ... parameters) {
        String s = "";
        Class<?>[] classArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            s = String.valueOf(s) + c.getSimpleName();
            ++n2;
        }
        return s;
    }
}

