/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.utils.reflection.helpers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import me.mirreski.random.utils.reflection.helpers.ConstructHelper;
import me.mirreski.random.utils.reflection.helpers.CoreClassHelper;
import me.mirreski.random.utils.reflection.helpers.HelperManager;
import me.mirreski.random.utils.reflection.helpers.ObjectHelper;

public class ClassHelper
extends CoreClassHelper {
    public ClassHelper(String className) {
        super(className);
    }

    public ClassHelper(Class<?> c) {
        super(c.getName());
    }

    public Class<?> toClass() {
        return HelperManager.getInstance().fetchClass(this.getName());
    }

    public Method getMethod(String methodName, Class<?> ... parameters) {
        return HelperManager.getInstance().fetchMethod(this.getName(), methodName, parameters);
    }

    public Field getField(String fieldName) {
        return HelperManager.getInstance().fetchField(this.getName(), fieldName);
    }

    public Constructor<?> getConstructor(Class<?> ... parameters) {
        return HelperManager.getInstance().fetchClassConstructor(this.getName(), parameters);
    }

    public ObjectHelper toObjectHelper(Object o) {
        return new ObjectHelper(o, this.getName());
    }

    public ObjectHelper ob(Object o) {
        return this.toObjectHelper(o);
    }

    public ObjectHelper staticHelper() {
        return this.toObjectHelper(null);
    }

    public ConstructHelper toConstructHelper(Class<?> ... parameters) {
        return new ConstructHelper(this.getName(), parameters);
    }

    public ConstructHelper toConstructHelper(String ... parameters) {
        return new ConstructHelper(this.getName(), parameters);
    }

    public ConstructHelper constructor(Class<?> ... parameters) {
        return this.toConstructHelper(parameters);
    }

    public ConstructHelper constructor(String ... parameters) {
        return this.toConstructHelper(parameters);
    }

    public ConstructHelper toConstructHelper() {
        return new ConstructHelper(this.getName(), null);
    }

    public Object invokeMethod(Object target, String methodName, Class<?>[] parameters, Object ... args) {
        return HelperManager.getInstance().invokeMethod(target, this.getName(), methodName, parameters, args);
    }

    public Object invokeMethod(Object target, String methodName) {
        return HelperManager.getInstance().invokeMethod(target, this.getName(), methodName);
    }

    public Object invokeMethod(Object target, String methodName, String[] parameters, Object ... args) {
        return HelperManager.getInstance().invokeMethod(target, this.getName(), methodName, parameters, args);
    }

    public Object getFromField(Object target, String fieldName) {
        return HelperManager.getInstance().getFromField(target, this.getName(), fieldName);
    }

    public void setField(Object target, String fieldName, Object value) {
        HelperManager.getInstance().setField(target, this.getName(), fieldName, value);
    }
}

