/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.utils.nms.villager;

import me.mirreski.random.utils.nms.villager.MerchantTrade;
import me.mirreski.random.utils.nms.villager.fakemerchant.FakeMerchant;
import me.mirreski.random.utils.nms.villager.fakemerchant.FakeMerchantFactory;
import me.mirreski.random.utils.nms.villager.fakemerchant.Merchant;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TradeGUI {
    private String title;
    private MerchantTrade[] trades;
    private boolean shiftDisabled = false;
    private boolean infiniteRecipes = false;
    private FakeMerchant fake = null;
    private Merchant merchant = null;

    public TradeGUI(String s, MerchantTrade ... mt) {
        this.setTitle(s);
        this.setTrades(mt);
    }

    public TradeGUI(Merchant m) {
        this.setMerchant(m);
        this.setFake(m.getFakeMerchant());
    }

    public String getInventoryName() {
        assert (this.getMerchant() != null);
        return this.getMerchant().getInventoryName();
    }

    public void setInventoryName(String s) {
        assert (this.getMerchant() != null);
        this.getMerchant().setInventoryName(s);
    }

    public void setSlot(int i, ItemStack is) {
        this.getMerchant().setSlot(i, is);
    }

    public ItemStack getSlot(int i) {
        assert (this.getMerchant() != null);
        return this.getMerchant().getSlot(i);
    }

    public void openTrade(Player p) {
        if (this.getFake() == null) {
            this.setFake(FakeMerchantFactory.getInstance().createFakeMerchant(p, this.getTitle(), this.getTrade()));
        }
        this.setMerchant(this.getFake().openTrade(this.isShiftDisabled(), this.isInfiniteRecipes()));
    }

    public Merchant getMerchant() {
        return this.merchant;
    }

    public void setMerchant(Merchant merchant) {
        this.merchant = merchant;
    }

    public static TradeGUI get(Player p) {
        return FakeMerchant.getGUI(p);
    }

    public FakeMerchant getFake() {
        return this.fake;
    }

    public void setFake(FakeMerchant fake) {
        this.fake = fake;
    }

    public MerchantTrade[] getTrade() {
        if (this.getFake() != null) {
            return this.getFake().getTrades();
        }
        return this.trades;
    }

    public void setTrades(MerchantTrade ... trade) {
        if (this.getFake() != null) {
            this.getFake().setTrades(trade);
        }
        this.trades = trade;
    }

    public String getTitle() {
        if (this.getFake() == null) {
            return this.title;
        }
        return this.getFake().getTitle();
    }

    public void setTitle(String title) {
        if (this.getFake() != null) {
            this.getFake().setTitle(title);
        }
        this.title = title;
    }

    public boolean isShiftDisabled() {
        return this.shiftDisabled;
    }

    public void setShiftDisabled(boolean shiftDisabled) {
        this.shiftDisabled = shiftDisabled;
    }

    public boolean isInfiniteRecipes() {
        return this.infiniteRecipes;
    }

    public void setInfiniteRecipes(boolean infiniteRecipes) {
        this.infiniteRecipes = infiniteRecipes;
    }
}

