/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.utils.nms.villager;

import me.mirreski.random.utils.CommonUtils;
import me.mirreski.random.utils.nms.villager.VillagerUtils;
import me.mirreski.random.utils.reflection.ClassGetter;
import me.mirreski.random.utils.reflection.helpers.ClassHelper;
import me.mirreski.random.utils.reflection.helpers.ClassType;
import me.mirreski.random.utils.reflection.helpers.ConstructHelper;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MerchantTrade
extends ClassGetter {
    private ItemStack firstItem;
    private ItemStack secondItem;
    private ItemStack thirdItem;
    private int maxUses;

    public MerchantTrade(ItemStack first, ItemStack second, ItemStack third, int maxUses) {
        this.setFirstItem(first);
        this.setSecondItem(second);
        this.setThirdItem(third);
        this.setMaxUses(maxUses);
    }

    public MerchantTrade(ItemStack first, ItemStack third, int maxUses) {
        this.setFirstItem(first);
        this.setSecondItem(new ItemStack(Material.AIR));
        this.setThirdItem(third);
        this.setMaxUses(maxUses);
    }

    public ItemStack getSecondItem() {
        return this.secondItem;
    }

    public boolean hasSecondItem() {
        return this.getSecondItem() != null && this.getSecondItem().getType() != Material.AIR;
    }

    public void setSecondItem(ItemStack secondItem) {
        this.secondItem = secondItem;
    }

    public ItemStack getFirstItem() {
        return this.firstItem;
    }

    public void setFirstItem(ItemStack firstItem) {
        this.firstItem = firstItem;
    }

    public ItemStack getThirdItem() {
        return this.thirdItem;
    }

    public void setThirdItem(ItemStack thirdItem) {
        this.thirdItem = thirdItem;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    public Object[] getOrderedNmsArray() {
        return new Object[]{CommonUtils.toNmsItemstack(this.getFirstItem()), CommonUtils.toNmsItemstack(this.getSecondItem()), CommonUtils.toNmsItemstack(this.getThirdItem())};
    }

    public Object toMerchantRecipe() {
        String itemStack = ClassType.NMS.get("ItemStack");
        ConstructHelper merchantRecipeConstructor = new ClassHelper(ClassType.NMS.get("MerchantRecipe")).toConstructHelper(itemStack, itemStack, itemStack);
        Object merchantRecipe = null;
        try {
            merchantRecipe = merchantRecipeConstructor.constructObject(this.getOrderedNmsArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (merchantRecipe != null) {
            VillagerUtils.setMaxUses(merchantRecipe, this.getMaxUses());
        }
        return merchantRecipe;
    }

    public static MerchantTrade toMerchantTrade(Object merchantRecipe) {
        ItemStack first = null;
        ItemStack second = null;
        ItemStack third = null;
        int i = 0;
        try {
            first = VillagerUtils.getBuyItem(merchantRecipe, 1);
            second = VillagerUtils.getBuyItem(merchantRecipe, 2);
            third = VillagerUtils.getBuyItem(merchantRecipe, 3);
            i = VillagerUtils.getMaxUses(merchantRecipe);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new MerchantTrade(first, second, third, i);
    }

    public boolean compare(MerchantTrade trade) {
        return this.getFirstItem().equals((Object)trade.getFirstItem()) && this.getSecondItem().equals((Object)trade.getSecondItem()) && this.getThirdItem().equals((Object)trade.getThirdItem()) && this.getMaxUses() == trade.getMaxUses();
    }

    public static Object createEmptyMerchantRecipe() {
        MerchantTrade trade = new MerchantTrade(new ItemStack(Material.AIR), new ItemStack(Material.AIR), new ItemStack(Material.AIR), 0);
        return trade.toMerchantRecipe();
    }
}

