/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.utils;

import me.mirreski.random.skript.RandomSK;
import me.mirreski.random.utils.enums.AnimationEnum;
import me.mirreski.random.utils.nms.packets.PacketSend;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class SleepHandler
implements Listener {
    public static void sleep(Player p, Block b, boolean excludeSelf, Player ... watchers) {
        p.teleport(b.getLocation());
        if (!excludeSelf) {
            p.setMetadata("BedAnimation", (MetadataValue)new FixedMetadataValue(RandomSK.getPlugin(), (Object)p.getAllowFlight()));
            p.setAllowFlight(true);
            p.setFlying(true);
            PlayerBedEnterEvent e = new PlayerBedEnterEvent(p, p.getLocation().getBlock());
            Bukkit.getPluginManager().callEvent((Event)e);
        }
        try {
            PacketSend.sleepAnimation(p, b, watchers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reset(Player p) {
        if (p.hasMetadata("BedAnimation")) {
            p.setFlying(false);
            Boolean b = ((MetadataValue)p.getMetadata("BedAnimation").iterator().next()).asBoolean();
            p.setAllowFlight(b.booleanValue());
            p.removeMetadata("BedAnimation", RandomSK.getPlugin());
        }
    }

    public static void reset(Player p, Player ... watchers) {
        try {
            PacketSend.animation((Entity)p, watchers, AnimationEnum.WAKEUP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SleepHandler.reset(p);
    }

    public static boolean hasBedAnimation(Player p) {
        return p.hasMetadata("BedAnimation");
    }

    @EventHandler
    public void OnPlayerDeath(PlayerDeathEvent event) {
        if (SleepHandler.hasBedAnimation(event.getEntity())) {
            SleepHandler.reset(event.getEntity());
        }
    }

    @EventHandler
    public void onPlayerquit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (SleepHandler.hasBedAnimation(player)) {
            SleepHandler.reset(player);
        }
    }

    @EventHandler
    public void onPlayerkick(PlayerKickEvent event) {
        Player player = event.getPlayer();
        if (SleepHandler.hasBedAnimation(player)) {
            SleepHandler.reset(player);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (SleepHandler.hasBedAnimation(player)) {
            SleepHandler.reset(player);
        }
    }
}

