/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.skript.features.velocity;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.mirreski.random.utils.skript.SkriptUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class ExprVectorToLocation
extends SimpleExpression<Location> {
    private Expression<Vector> vector;
    private Expression<World> world;
    private Expression<Number> yaw;
    private Expression<Number> pitch;
    private int parseMark;

    static {
        SkriptUtils.registerExpression(ExprVectorToLocation.class, Location.class, ExpressionType.PROPERTY, "%vector% to location of %world%", "%vector% to location of %world% with yaw %number% and pitch %number%");
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] exprs, int parse, Kleenean kl, SkriptParser.ParseResult pr) {
        this.vector = exprs[0];
        this.world = exprs[1];
        if (parse == 1) {
            this.yaw = exprs[2];
            this.pitch = exprs[3];
        }
        this.parseMark = parse;
        return true;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "Vector to Location";
    }

    @Nullable
    protected Location[] get(Event event) {
        Vector v = (Vector)this.vector.getSingle(event);
        World w = (World)this.world.getSingle(event);
        if (v == null || w == null) {
            return null;
        }
        Location l = null;
        if (this.parseMark == 0) {
            l = v.toLocation(w);
        } else if (this.parseMark == 1) {
            Number y = (Number)this.yaw.getSingle(event);
            Number p = (Number)this.pitch.getSingle(event);
            if (y == null || p == null) {
                return null;
            }
            l = v.toLocation(w, y.floatValue(), p.floatValue());
        }
        return new Location[]{l};
    }
}

