/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.skript.features.velocity;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.mirreski.random.utils.skript.SkriptUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class ExprVectorArithmetic
extends SimpleExpression<Vector> {
    private static final Patterns<Operator> patterns = new Patterns((Object[][])new Object[][]{{"vector %vector%[ ]+[ ]%vector%", Operator.PLUS}, {"vector %vector%[ ]-[ ]%vector%", Operator.MINUS}, {"vector %vector%[ ]*[ ]%vector/number%", Operator.MULT}, {"vector %vector%[ ]/[ ]%vector/number%", Operator.DIV}});
    private Expression<? extends Vector> first;
    private Expression<? extends Object> second;
    private Operator op;

    static {
        SkriptUtils.registerExpression(ExprVectorArithmetic.class, Vector.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, patterns.getPatterns());
    }

    public boolean init(Expression<?>[] exprs, int parse, Kleenean kl, SkriptParser.ParseResult pr) {
        this.first = exprs[0];
        this.second = exprs[1];
        this.op = (Operator)((Object)patterns.getInfo(parse));
        return true;
    }

    protected Vector[] get(Event event) {
        Vector vector = (Vector)this.first.getSingle(event);
        Object other = this.second.getSingle(event);
        if (vector == null || other == null) {
            return null;
        }
        if (!(other instanceof Vector) && !(other instanceof Number)) {
            return null;
        }
        Vector finalVector = this.op.calculate(vector, other);
        return new Vector[]{finalVector};
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.first.toString(e, debug)) + " " + (Object)((Object)this.op) + " " + this.second.toString(e, debug);
    }

    private static enum Operator {
        PLUS('+'){

            @Override
            public Vector calculate(Vector v1, Object v2) {
                Vector copy = v1.clone();
                return copy.add((Vector)v2);
            }
        }
        ,
        MINUS('-'){

            @Override
            public Vector calculate(Vector v1, Object v2) {
                Vector copy = v1.clone();
                return copy.subtract((Vector)v2);
            }
        }
        ,
        MULT('*'){

            @Override
            public Vector calculate(Vector v1, Object v2) {
                Vector copy = v1.clone();
                if (v2 instanceof Vector) {
                    return copy.multiply((Vector)v2);
                }
                if (v2 instanceof Number) {
                    return copy.multiply(((Number)v2).doubleValue());
                }
                return null;
            }
        }
        ,
        DIV('/'){

            @Override
            public Vector calculate(Vector v1, Object v2) {
                Vector copy = v1.clone();
                if (v2 instanceof Vector) {
                    return copy.divide((Vector)v2);
                }
                if (v2 instanceof Number) {
                    return copy.multiply(1.0 / ((Number)v2).doubleValue());
                }
                return null;
            }
        };

        public final char sign;

        private Operator(char sign) {
            this.sign = sign;
        }

        public abstract Vector calculate(Vector var1, Object var2);

        public String toString() {
            return "" + this.sign;
        }
    }
}

