/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.skript.features.packet;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.mirreski.random.utils.PlayerUtils;
import me.mirreski.random.utils.RandomGenerator;
import me.mirreski.random.utils.nms.packets.BlockBreakAnimation;
import me.mirreski.random.utils.skript.SkriptUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class EffBlockBreakAnimation
extends Effect {
    private Expression<Number> stage;
    private Expression<Player> watchers;
    private Expression<Block> block;
    private int syntax;

    static {
        SkriptUtils.registerEffect(EffBlockBreakAnimation.class, "show block break [animation] stage %number% at %block% for %players%", "show block break [animation] stage %number% at %block%", "show stacking block break [animation] stage %number% at %block%", "show stacking block break [animation] stage %number% at %block% for %players");
    }

    protected void execute(Event event) {
        Block b = (Block)this.block.getSingle(event);
        Number n = (Number)this.stage.getSingle(event);
        if (n.intValue() - 1 > 9 || n.intValue() < 0 || b == null || n == null) {
            return;
        }
        BlockBreakAnimation bba = null;
        if (this.syntax == 0 || this.syntax == 1) {
            bba = new BlockBreakAnimation(b, n, RandomGenerator.nextInt(), false);
        } else if (this.syntax == 2 || this.syntax == 3) {
            bba = new BlockBreakAnimation(b, n, RandomGenerator.nextInt(), true);
        }
        if (this.syntax == 0 || this.syntax == 2) {
            Player[] watcher = (Player[])this.watchers.getAll(event);
            try {
                bba.sendAnimation(watcher);
            }
            catch (Exception exception) {}
        } else if (this.syntax == 1 || this.syntax == 3) {
            Player[] plist = PlayerUtils.getPlayersInRadius(null, b.getLocation(), b.getWorld(), true, 2500);
            try {
                bba.sendAnimation(plist);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString(Event event, boolean b) {
        return "Block Break Animation";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.syntax = i;
        this.stage = expressions[0];
        this.block = expressions[1];
        if (this.syntax == 0 || this.syntax == 3) {
            this.watchers = expressions[2];
        }
        return true;
    }
}

