/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.skript.features.inventory.merchant.gui;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.mirreski.random.utils.nms.villager.TradeGUI;
import me.mirreski.random.utils.nms.villager.fakemerchant.FakeMerchantFactory;
import me.mirreski.random.utils.skript.SkriptUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprSlotOfGUI
extends SimpleExpression<ItemStack> {
    private Expression<Number> slotNumber;
    private Expression<TradeGUI> tradeGUI;

    static {
        if (FakeMerchantFactory.supportsVersion()) {
            SkriptUtils.registerExpression(ExprSlotOfGUI.class, ItemStack.class, ExpressionType.PROPERTY, SkriptUtils.createProperty("trade slot %number%", "%guitrade%"));
        }
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] e, int parse, Kleenean kl, SkriptParser.ParseResult pr) {
        if (parse == 0) {
            this.slotNumber = e[0];
            this.tradeGUI = e[1];
        } else if (parse == 1) {
            this.slotNumber = e[1];
            this.tradeGUI = e[0];
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "Slot of Trade GUI";
    }

    @Nullable
    protected ItemStack[] get(Event event) {
        Number n = (Number)this.slotNumber.getSingle(event);
        TradeGUI gui = (TradeGUI)this.tradeGUI.getSingle(event);
        if (n == null || gui == null || n.intValue() > 2 || n.intValue() < 0) {
            return null;
        }
        return new ItemStack[]{gui.getSlot(n.intValue())};
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Number n = (Number)this.slotNumber.getSingle(event);
        TradeGUI gui = (TradeGUI)this.tradeGUI.getSingle(event);
        ItemStack is = (ItemStack)delta[0];
        if (n == null || gui == null || n.intValue() > 1 || n.intValue() <= 0 || is == null) {
            return;
        }
        gui.setSlot(n.intValue(), is);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemStack.class});
        }
        return null;
    }
}

