/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.skript.features.inventory.merchant.gui;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.mirreski.random.utils.enums.GuiOption;
import me.mirreski.random.utils.nms.villager.TradeGUI;
import me.mirreski.random.utils.nms.villager.fakemerchant.FakeMerchantFactory;
import me.mirreski.random.utils.skript.SkriptUtils;
import org.bukkit.event.Event;

public class ExprGUIOptions
extends SimpleExpression<Boolean> {
    private Expression<GuiOption> option;
    private Expression<TradeGUI> tradeGUI;

    static {
        if (FakeMerchantFactory.supportsVersion()) {
            SkriptUtils.registerExpression(ExprGUIOptions.class, Boolean.class, ExpressionType.COMBINED, "[trade ]gui option %guioption% of %guitrade%", "%guitrade%'s [trade ]gui option %guioption%");
        }
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] e, int parse, Kleenean kl, SkriptParser.ParseResult pr) {
        if (parse == 0) {
            this.option = e[0];
            this.tradeGUI = e[1];
        } else if (parse == 1) {
            this.tradeGUI = e[0];
            this.option = e[1];
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "Option of Trade GUI";
    }

    @Nullable
    protected Boolean[] get(Event event) {
        GuiOption o = (GuiOption)((Object)this.option.getSingle(event));
        TradeGUI gui = (TradeGUI)this.tradeGUI.getSingle(event);
        if (o == null || gui == null) {
            return null;
        }
        switch (o) {
            case SHIFTDISABLED: {
                return new Boolean[]{gui.isShiftDisabled()};
            }
            case INFINITE_RECIPES: {
                return new Boolean[]{gui.isInfiniteRecipes()};
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        TradeGUI gui = (TradeGUI)this.tradeGUI.getSingle(e);
        GuiOption o = (GuiOption)((Object)this.option.getSingle(e));
        Boolean b = (Boolean)delta[0];
        if (gui == null || b == null || o == null) {
            return;
        }
        if (gui.getFake() == null) {
            switch (o) {
                case SHIFTDISABLED: {
                    gui.setShiftDisabled(b);
                    break;
                }
                case INFINITE_RECIPES: {
                    gui.setInfiniteRecipes(b);
                    break;
                }
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }
}

