/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.skript.features.inventory.merchant;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import me.mirreski.random.utils.nms.villager.MerchantTrade;
import me.mirreski.random.utils.skript.SkriptUtils;
import org.bukkit.event.Event;

public class ExprMaxUses
extends SimplePropertyExpression<MerchantTrade, Number> {
    static {
        SkriptUtils.register(ExprMaxUses.class, Number.class, "max uses", "trade");
    }

    public Number convert(MerchantTrade mt) {
        if (mt == null) {
            return null;
        }
        return mt.getMaxUses();
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        MerchantTrade mt = (MerchantTrade)this.getExpr().getSingle(e);
        Number n = (Number)delta[0];
        if (n == null || mt == null) {
            return;
        }
        int i = n.intValue();
        switch (mode) {
            case ADD: {
                i += mt.getMaxUses();
                break;
            }
            case DELETE: {
                break;
            }
            case REMOVE: {
                i -= mt.getMaxUses();
                break;
            }
            case REMOVE_ALL: {
                break;
            }
            case RESET: {
                break;
            }
            case SET: {
                break;
            }
        }
        if (i < 0) {
            i = 0;
        }
        mt.setMaxUses(i);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "max uses of %trade%";
    }
}

