/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.skript.features.entity.player;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Set;
import javax.annotation.Nullable;
import me.mirreski.random.utils.skript.SkriptUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ExprChatRecipients
extends SimpleExpression<Player> {
    static {
        SkriptUtils.registerExpression(ExprChatRecipients.class, Player.class, ExpressionType.SIMPLE, "[chat ]recipients");
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Player.class});
        }
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(AsyncPlayerChatEvent.class)) {
            Skript.error((String)"Cannot use chat recipients expression outside of a chat event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "chat recipients";
    }

    @Nullable
    protected Player[] get(Event e) {
        AsyncPlayerChatEvent ae = (AsyncPlayerChatEvent)e;
        Set playerSet = ae.getRecipients();
        return playerSet.toArray(new Player[playerSet.size()]);
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Player[] playerArray = (Player[])delta;
        AsyncPlayerChatEvent a = (AsyncPlayerChatEvent)e;
        switch (mode) {
            case REMOVE: {
                Player[] playerArray2 = playerArray;
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player p = playerArray2[n2];
                    a.getRecipients().remove(p);
                    ++n2;
                }
                break;
            }
            case DELETE: {
                a.getRecipients().clear();
                break;
            }
            case ADD: {
                Player[] playerArray3 = playerArray;
                int n = playerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Player p = playerArray3[n3];
                    a.getRecipients().add(p);
                    ++n3;
                }
                break;
            }
            case SET: {
                a.getRecipients().clear();
                Player[] playerArray4 = playerArray;
                int n = playerArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Player p = playerArray4[n4];
                    a.getRecipients().add(p);
                    ++n4;
                }
                break;
            }
        }
    }
}

