/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.skript.features.block;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.mirreski.random.utils.BlockFeature;
import me.mirreski.random.utils.skript.SkriptUtils;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class ExprBlockFeatures
extends SimpleExpression<Timespan> {
    private Expression<Block> block;
    private int parseMark;

    static {
        SkriptUtils.registerExpression(ExprBlockFeatures.class, Timespan.class, ExpressionType.PROPERTY, "brew[ing] time of %block%", "burn[ing] time of %block%", "cook[ing] time of %block%", "[mob] spawn delay of %block%");
    }

    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] exprs, int parse, Kleenean kl, SkriptParser.ParseResult pr) {
        this.block = exprs[0];
        this.parseMark = parse;
        return true;
    }

    public String toString(@Nullable Event event, boolean b) {
        if (this.parseMark == 0) {
            return "Brewing time of %block%";
        }
        if (this.parseMark == 1) {
            return "Burning time of %block%";
        }
        if (this.parseMark == 2) {
            return "Cooking time of %block%";
        }
        return "Mob spawn delay of %block%";
    }

    @Nullable
    protected Timespan[] get(Event event) {
        Block b = (Block)this.block.getSingle(event);
        if (b == null) {
            return null;
        }
        BlockFeature bf = BlockFeature.getBlockFeature(this.parseMark);
        Number n = null;
        try {
            n = bf.get(b);
        }
        catch (Exception ex) {
            return null;
        }
        return new Timespan[]{Timespan.fromTicks((int)n.intValue())};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Block b = (Block)this.block.getSingle(e);
        Timespan time = (Timespan)delta[0];
        if (b == null || time == null) {
            return;
        }
        BlockFeature bf = BlockFeature.getBlockFeature(this.parseMark);
        Number n = bf.get(b);
        if (n == null) {
            return;
        }
        Integer dur = null;
        switch (mode) {
            case ADD: {
                dur = n.intValue() + time.getTicks();
                break;
            }
            case DELETE: {
                break;
            }
            case REMOVE: {
                dur = n.intValue() - time.getTicks();
                break;
            }
            case REMOVE_ALL: {
                break;
            }
            case RESET: {
                break;
            }
            case SET: {
                dur = time.getTicks();
                break;
            }
        }
        bf.set(b, dur);
    }
}

