/*
 * Decompiled with CFR 0.152.
 */
package me.mirreski.random.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.IOException;
import java.util.List;
import me.mirreski.random.utils.SleepHandler;
import me.mirreski.random.utils.nms.villager.fakemerchant.FakeMerchantFactory;
import me.mirreski.random.utils.skript.FeatureManager;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RandomSK
extends JavaPlugin {
    private static Plugin plugin;
    private static SkriptAddon addon;
    public static String BUKKIT_VERSION;
    public static int VERSION;
    public static String CONFIG_VERSION;

    static {
        BUKKIT_VERSION = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        VERSION = Integer.parseInt(BUKKIT_VERSION.replaceAll("v", "").replaceAll("_", "").replaceAll("R", ""));
        CONFIG_VERSION = "2.0 Final Beta";
    }

    public void onEnable() {
        SkriptAddon sa = Skript.registerAddon((JavaPlugin)this);
        RandomSK.setAddon(sa);
        if (!this.getConfig().contains("ConfigVersion")) {
            this.overwriteConfig();
            this.reloadConfig();
        }
        this.saveDefaultConfig();
        String configVersion = this.getConfig().getString("ConfigVersion");
        if (!configVersion.equalsIgnoreCase(CONFIG_VERSION)) {
            Bukkit.getLogger().info("[RandomSK] New Config Version. Overwritting Config..");
            this.overwriteConfig();
            this.reloadConfig();
        }
        plugin = this;
        this.getServer().getPluginManager().registerEvents((Listener)new SleepHandler(), plugin);
        List features = this.getConfig().getStringList("Features");
        this.registerFeatures(features);
        if (!FakeMerchantFactory.supportsVersion()) {
            Bukkit.getLogger().info("[RandomSK] Custom Trade GUI's aren't supported in this version, So they are disabled.");
        }
    }

    public void onDisable() {
        plugin = null;
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static SkriptAddon getAddon() {
        return addon;
    }

    public static void setAddon(SkriptAddon addon) {
        RandomSK.addon = addon;
    }

    public void registerFeatures(List<String> features) {
        boolean debug = this.getConfig().getBoolean("DebugRegister");
        for (String f : features) {
            if (!f.contains(" !")) {
                FeatureManager.addFeature(f);
                if (!debug) continue;
                Bukkit.getLogger().info("[RandomSK] Enabling feature " + f + ".");
                continue;
            }
            String[] split = f.split(" !");
            FeatureManager.addFeature(split[0], split[1]);
            if (!debug) continue;
            Bukkit.getLogger().info("[RandomSK] Enabling feature " + split[0] + " if addon " + split[1] + " is not present.");
        }
        try {
            RandomSK.getAddon().loadClasses("me.mirreski.random.skript", new String[]{"features"});
        }
        catch (IOException e) {
            this.setEnabled(false);
            return;
        }
    }

    public void overwriteConfig() {
        this.saveResource("config.yml", true);
    }
}

