/*
 * Decompiled with CFR 0.152.
 */
package me.Mirreducki.Random.Utils.Reflection.Helpers;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import me.Mirreducki.Random.Utils.Reflection.Helpers.Interface.Helper;

public class MethodHelper
implements Helper {
    public static Map<String, Method> methods = new HashMap<String, Method>();
    private Method fetchedMethod;

    public MethodHelper(Class<?> c, String methodName) {
        if (methods.containsKey(String.valueOf(c.getName()) + methodName)) {
            this.setFetchedMethod(methods.get(String.valueOf(c.getName()) + methodName));
        } else {
            Method m = null;
            try {
                m = c.getMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            if (m != null) {
                methods.put(String.valueOf(c.getName()) + methodName, m);
            }
            this.setFetchedMethod(m);
        }
    }

    public MethodHelper(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        if (methods.containsKey(String.valueOf(c.getName()) + methodName + parameterTypes.length)) {
            this.setFetchedMethod(methods.get(String.valueOf(c.getName()) + methodName + parameterTypes.length));
        } else {
            Method m = null;
            try {
                m = c.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            if (m != null) {
                methods.put(String.valueOf(c.getName()) + methodName + parameterTypes.length, m);
            }
            this.setFetchedMethod(m);
        }
    }

    public Method getFetchedMethod() {
        return this.fetchedMethod;
    }

    public void setFetchedMethod(Method fetchedMethod) {
        this.fetchedMethod = fetchedMethod;
    }

    public Object invokeMethod(Object target, Object ... args) {
        assert (this.getFetchedMethod() != null);
        try {
            return this.getFetchedMethod().invoke(target, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object invokeMethod(Object target) {
        assert (this.getFetchedMethod() != null);
        try {
            return this.getFetchedMethod().invoke(target, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object invokeStaticMethod(Object target) {
        assert (this.getFetchedMethod() != null);
        try {
            return this.getFetchedMethod().invoke(null, target);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

