/*
 * Decompiled with CFR 0.152.
 */
package me.Mirreducki.Random.Utils.Reflection.Helpers;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.Mirreducki.Random.Utils.Reflection.ClassGetter;
import me.Mirreducki.Random.Utils.Reflection.Helpers.Interface.Helper;

public class ConstructHelper
implements Helper {
    public static Map<String, Constructor<?>> constructors = new HashMap();
    private Constructor<?> fetchedConstructor;

    public ConstructHelper(Class<?> c) {
        if (constructors.containsKey(c.getName())) {
            this.setFetchedConstructor(constructors.get(c.getName()));
        } else {
            Constructor<?> con = null;
            try {
                con = ClassGetter.getConstructor(c);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (!con.isAccessible()) {
                con.setAccessible(true);
            }
            if (con != null) {
                constructors.put(c.getName(), con);
            }
            this.setFetchedConstructor(con);
        }
    }

    public ConstructHelper(Class<?> c, int i) {
        if (constructors.containsKey(String.valueOf(c.getName()) + i)) {
            this.setFetchedConstructor(constructors.get(String.valueOf(c.getName()) + i));
        } else {
            Constructor<?> con = null;
            try {
                con = ClassGetter.getConstructor(c, i);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (!con.isAccessible()) {
                con.setAccessible(true);
            }
            if (con != null) {
                constructors.put(String.valueOf(c.getName()) + i, con);
            }
            this.setFetchedConstructor(con);
        }
    }

    public Constructor<?> getFetchedConstructor() {
        return this.fetchedConstructor;
    }

    public void setFetchedConstructor(Constructor<?> fetchedConstructor) {
        this.fetchedConstructor = fetchedConstructor;
    }

    public Object constructObject(Object ... objects) throws Exception {
        List<Object> list;
        Constructor<?> c = this.getFetchedConstructor();
        if (!c.isAccessible()) {
            c.setAccessible(true);
        }
        if ((list = Arrays.asList(objects)).isEmpty()) {
            return c.newInstance(new Object[0]);
        }
        Iterator<Object> iterator = list.iterator();
        Object result = null;
        switch (c.getParameterTypes().length) {
            case 1: {
                result = c.newInstance(iterator.next());
                break;
            }
            case 2: {
                result = c.newInstance(iterator.next(), iterator.next());
                break;
            }
            case 3: {
                result = c.newInstance(iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case 4: {
                result = c.newInstance(iterator.next(), iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case 5: {
                result = c.newInstance(iterator.next(), iterator.next(), iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case 6: {
                result = c.newInstance(iterator.next(), iterator.next(), iterator.next(), iterator.next(), iterator.next(), iterator.next());
                break;
            }
            case 7: {
                result = c.newInstance(iterator.next(), iterator.next(), iterator.next(), iterator.next(), iterator.next(), iterator.next(), iterator.next());
            }
        }
        return result;
    }

    public Object newInstance() {
        try {
            return this.getFetchedConstructor().newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

