/*
 * Decompiled with CFR 0.152.
 */
package me.Mirreducki.Random.Utils.Reflection.Helpers;

import java.util.HashMap;
import java.util.Map;
import me.Mirreducki.Random.Utils.Reflection.ClassGetter;
import me.Mirreducki.Random.Utils.Reflection.Helpers.ConstructHelper;
import me.Mirreducki.Random.Utils.Reflection.Helpers.Enum.ClassType;
import me.Mirreducki.Random.Utils.Reflection.Helpers.Extension.FieldChanger;
import me.Mirreducki.Random.Utils.Reflection.Helpers.Extension.Invoker;
import me.Mirreducki.Random.Utils.Reflection.Helpers.FieldHelper;
import me.Mirreducki.Random.Utils.Reflection.Helpers.Interface.Helper;
import me.Mirreducki.Random.Utils.Reflection.Helpers.MethodHelper;

public class ClassHelper
implements Helper {
    public static Map<String, Class<?>> classes = new HashMap();
    private Class<?> fetchedClass;

    public ClassHelper(String className, ClassType type) {
        if (classes.containsKey(String.valueOf(className) + type.toString())) {
            this.setFetchedClass(classes.get(String.valueOf(className) + type.toString()));
        } else {
            Class<?> c = this.fetchClass(className, type);
            if (c != null) {
                classes.put(String.valueOf(className) + type.toString(), c);
            }
            this.setFetchedClass(c);
        }
    }

    public ClassHelper(Class<?> c, ClassType type) {
        String s = null;
        if (type == ClassType.UNKNOWN) {
            s = c.getName();
        } else if (type == ClassType.NMS || type == ClassType.CB) {
            s = c.getSimpleName();
        }
        if (classes.containsKey(String.valueOf(s) + type.toString())) {
            this.setFetchedClass(c);
        } else {
            classes.put(String.valueOf(s) + type.toString(), c);
            this.setFetchedClass(c);
        }
    }

    public Class<?> getFetchedClass() {
        return this.fetchedClass;
    }

    public void setFetchedClass(Class<?> fetchedClass) {
        this.fetchedClass = fetchedClass;
    }

    public Class<?> fetchClass(String className, ClassType type) {
        Class<?> c = null;
        switch (type) {
            case CB: {
                try {
                    c = ClassGetter.getCraftClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
            case NMS: {
                try {
                    c = ClassGetter.getMCClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
            case UNKNOWN: {
                try {
                    c = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return c;
    }

    public FieldHelper getFieldHelper(String fieldName) {
        return new FieldHelper(this.getFetchedClass(), fieldName);
    }

    public FieldChanger getFieldChanger(String fieldName, Object target) {
        return new FieldChanger(target, this.getFetchedClass(), fieldName);
    }

    public MethodHelper getMethodHelper(String methodName) {
        return new MethodHelper(this.getFetchedClass(), methodName);
    }

    public MethodHelper getMethodHelper(String methodName, Class<?> ... parameterTypes) {
        return new MethodHelper(this.getFetchedClass(), methodName, parameterTypes);
    }

    public ConstructHelper getConstructHelper() {
        return new ConstructHelper(this.getFetchedClass());
    }

    public ConstructHelper getConstructHelper(int parameterLength) {
        return new ConstructHelper(this.getFetchedClass(), parameterLength);
    }

    public Invoker getInvoker(String methodName, Object target) {
        return new Invoker(target, this.getFetchedClass(), methodName);
    }

    public Invoker getInvoker(String methodName, Object target, Class<?> ... parameterTypes) {
        return new Invoker(target, this.getFetchedClass(), methodName, parameterTypes);
    }
}

