/*
 * Decompiled with CFR 0.152.
 */
package me.Mirreducki.Random.Utils.NMS.Villager;

import java.util.ArrayList;
import me.Mirreducki.Random.Utils.NMS.Villager.MerchantTrade;
import me.Mirreducki.Random.Utils.NMS.Villager.VillagerUtils;
import org.bukkit.entity.Villager;

public class TradeFactory {
    private Villager villager;
    private ArrayList merchantRecipeList = new ArrayList();

    public TradeFactory(Villager v) {
        this.setVillager(v);
        this.getTradeList();
    }

    public ArrayList getMerchantRecipeList() {
        return this.merchantRecipeList;
    }

    public void setMerchantRecipeList(ArrayList list) {
        this.merchantRecipeList = list;
    }

    public Villager getVillager() {
        return this.villager;
    }

    public void setVillager(Villager villager) {
        this.villager = villager;
    }

    public void setSingleOffer(MerchantTrade merchantRec, int location) {
        ArrayList list = this.getMerchantRecipeList();
        if (!this.hasOffer(location).booleanValue()) {
            this.addOffers(merchantRec);
            return;
        }
        list.set(location, merchantRec.toMerchantRecipe());
        this.setMerchantRecipeList(list);
    }

    public void addOffers(MerchantTrade ... merchantRecs) {
        ArrayList list = this.getMerchantRecipeList();
        MerchantTrade[] merchantTradeArray = merchantRecs;
        int n = merchantRecs.length;
        int n2 = 0;
        while (n2 < n) {
            MerchantTrade mt = merchantTradeArray[n2];
            list.add(mt.toMerchantRecipe());
            ++n2;
        }
        this.setMerchantRecipeList(list);
    }

    public void removeOffer(int location) {
        Boolean b = this.hasOffer(location);
        if (b == null || !b.booleanValue()) {
            return;
        }
        ArrayList list = this.getMerchantRecipeList();
        list.remove(location);
        this.setMerchantRecipeList(list);
    }

    public MerchantTrade getMerchantOffer(int location) {
        Boolean hasOffer = this.hasOffer(location);
        if (hasOffer == null || !hasOffer.booleanValue()) {
            return null;
        }
        return MerchantTrade.toMerchantTrade(this.getNMSOffer(location));
    }

    public Object getNMSOffer(int location) {
        Boolean hasOffer = this.hasOffer(location);
        if (hasOffer == null || !hasOffer.booleanValue()) {
            return null;
        }
        ArrayList list = this.getMerchantRecipeList();
        return list.get(location);
    }

    public MerchantTrade[] getAllTrades() {
        Boolean hasNoTrades = this.isOffersEmpty();
        if (hasNoTrades == null || hasNoTrades.booleanValue()) {
            return null;
        }
        ArrayList list = this.getMerchantRecipeList();
        ArrayList<MerchantTrade> result = new ArrayList<MerchantTrade>();
        for (Object o : list) {
            result.add(MerchantTrade.toMerchantTrade(o));
        }
        return result.toArray(new MerchantTrade[result.size()]);
    }

    public Boolean hasOffer(int location) {
        ArrayList list = this.getMerchantRecipeList();
        if (list.size() > location + 1) {
            return true;
        }
        if (list.size() < location + 1) {
            return false;
        }
        if (list.size() == location + 1) {
            return true;
        }
        return null;
    }

    public Boolean isOffersEmpty() {
        ArrayList list = this.getMerchantRecipeList();
        return list.isEmpty();
    }

    public void clearMerchantRecipeList() {
        try {
            VillagerUtils.clearMerchantItems(this.getVillager());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getTradeList() {
        try {
            this.setMerchantRecipeList(VillagerUtils.getRawOffers(this.getVillager()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void executeChanges() {
        if (this.isOffersEmpty().booleanValue()) {
            return;
        }
        try {
            VillagerUtils.setOffers(this.getVillager(), this.getMerchantRecipeList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

