/*
 * Decompiled with CFR 0.152.
 */
package me.Mirreducki.Random.Utils.NMS.Villager;

import me.Mirreducki.Random.Utils.NMS.Villager.VillagerUtils;
import me.Mirreducki.Random.Utils.Reflection.ClassGetter;
import me.Mirreducki.Random.Utils.Reflection.CommonUtils;
import me.Mirreducki.Random.Utils.Reflection.Helpers.ClassHelper;
import me.Mirreducki.Random.Utils.Reflection.Helpers.ConstructHelper;
import me.Mirreducki.Random.Utils.Reflection.Helpers.Enum.ClassType;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MerchantTrade
extends ClassGetter {
    private ItemStack firstItem;
    private ItemStack secondItem;
    private ItemStack thirdItem;
    private int maxUses;

    public MerchantTrade(ItemStack first, ItemStack second, ItemStack third, int maxUses) {
        this.setFirstItem(first);
        this.setSecondItem(second);
        this.setThirdItem(third);
        this.setMaxUses(maxUses);
    }

    public MerchantTrade(ItemStack first, ItemStack third, int maxUses) {
        this.setFirstItem(first);
        this.setSecondItem(new ItemStack(Material.AIR));
        this.setThirdItem(third);
        this.setMaxUses(maxUses);
    }

    public ItemStack getSecondItem() {
        return this.secondItem;
    }

    public boolean hasSecondItem() {
        return this.getSecondItem() != null && this.getSecondItem().getType() != Material.AIR;
    }

    public void setSecondItem(ItemStack secondItem) {
        this.secondItem = secondItem;
    }

    public ItemStack getFirstItem() {
        return this.firstItem;
    }

    public void setFirstItem(ItemStack firstItem) {
        this.firstItem = firstItem;
    }

    public ItemStack getThirdItem() {
        return this.thirdItem;
    }

    public void setThirdItem(ItemStack thirdItem) {
        this.thirdItem = thirdItem;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    public Object[] getOrderedNmsArray() {
        return new Object[]{CommonUtils.toNmsItemstack(this.getFirstItem()), CommonUtils.toNmsItemstack(this.getSecondItem()), CommonUtils.toNmsItemstack(this.getThirdItem())};
    }

    public Object toMerchantRecipe() {
        ClassHelper classHelper = new ClassHelper("MerchantRecipe", ClassType.NMS);
        ConstructHelper constructHelper = classHelper.getConstructHelper(3);
        Object merchantRecipe = null;
        try {
            merchantRecipe = constructHelper.constructObject(this.getOrderedNmsArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VillagerUtils.setMaxUses(merchantRecipe, this.getMaxUses());
        return merchantRecipe;
    }

    public static MerchantTrade toMerchantTrade(Object merchantRecipe) {
        ItemStack first = null;
        ItemStack second = null;
        ItemStack third = null;
        int i = 0;
        try {
            first = VillagerUtils.getBuyItem(merchantRecipe, 1);
            second = VillagerUtils.getBuyItem(merchantRecipe, 2);
            third = VillagerUtils.getBuyItem(merchantRecipe, 3);
            i = VillagerUtils.getMaxUses(merchantRecipe);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new MerchantTrade(first, second, third, i);
    }

    public boolean compare(MerchantTrade trade) {
        return this.getFirstItem().equals((Object)trade.getFirstItem()) && this.getSecondItem().equals((Object)trade.getSecondItem()) && this.getThirdItem().equals((Object)trade.getThirdItem()) && this.getMaxUses() == trade.getMaxUses();
    }
}

