/*
 * Decompiled with CFR 0.152.
 */
package me.Mirreducki.SK.Utils.Nms.Villager;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import me.Mirreducki.SK.Utils.Nms.Villager.TradeVillage;
import me.Mirreducki.SK.Utils.Refl.ClassGetter;
import me.Mirreducki.SK.Utils.Refl.ConstructHelper;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MerchantTrade
extends ClassGetter {
    private ItemStack firstItem;
    private ItemStack secondItem;
    private ItemStack thirdItem;
    private int maxUses;

    public MerchantTrade(ItemStack first, ItemStack second, ItemStack third, int maxUses) {
        this.setFirstItem(first);
        this.setSecondItem(second);
        this.setThirdItem(third);
        this.setMaxUses(maxUses);
    }

    public MerchantTrade(ItemStack first, ItemStack third, int maxUses) {
        this.setFirstItem(first);
        this.setSecondItem(new ItemStack(Material.AIR));
        this.setThirdItem(third);
        this.setMaxUses(maxUses);
    }

    public ItemStack getSecondItem() {
        return this.secondItem;
    }

    public boolean hasSecondItem() {
        return this.getSecondItem() != null && this.getSecondItem().getType() != Material.AIR;
    }

    public void setSecondItem(ItemStack secondItem) {
        this.secondItem = secondItem;
    }

    public ItemStack getFirstItem() {
        return this.firstItem;
    }

    public void setFirstItem(ItemStack firstItem) {
        this.firstItem = firstItem;
    }

    public ItemStack getThirdItem() {
        return this.thirdItem;
    }

    public void setThirdItem(ItemStack thirdItem) {
        this.thirdItem = thirdItem;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    public List<Object> getOrderedNmsArray() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(TradeVillage.toNmsItemstack(this.getFirstItem()));
        list.add(TradeVillage.toNmsItemstack(this.getSecondItem()));
        list.add(TradeVillage.toNmsItemstack(this.getThirdItem()));
        return list;
    }

    public Object toMerchantRecipe() {
        Constructor<?> c = null;
        List<Object> list = new ArrayList<Object>();
        try {
            c = MerchantTrade.getMCConstructor("MerchantRecipe", 3);
            list = this.getOrderedNmsArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConstructHelper ch = new ConstructHelper(c, list);
        Object merchantRecipe = null;
        try {
            merchantRecipe = ch.constructObject();
            TradeVillage.setMaxUses(merchantRecipe, this.getMaxUses());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return merchantRecipe;
    }

    public static MerchantTrade toMerchantTrade(Object merchantRecipe) {
        ItemStack first = null;
        ItemStack second = null;
        ItemStack third = null;
        int i = 0;
        try {
            first = TradeVillage.getBuyItem(merchantRecipe, 1);
            second = TradeVillage.getBuyItem(merchantRecipe, 2);
            third = TradeVillage.getBuyItem(merchantRecipe, 3);
            i = TradeVillage.getMaxUses(merchantRecipe);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new MerchantTrade(first, second, third, i);
    }
}

