/*
 * Decompiled with CFR 0.152.
 */
package me.Mirreducki.SK.Utils.Stuff;

import me.Mirreducki.SK.SkriptMirre;
import me.Mirreducki.SK.Utils.Enums.AnimationEnum;
import me.Mirreducki.SK.Utils.Stuff.Nms.Packets.PacketSend;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class SleepHandler
implements Listener {
    public static void sleep(Player p, Block b, boolean excludeSelf, Player ... watchers) {
        p.teleport(b.getLocation());
        if (!excludeSelf) {
            p.setFlying(true);
            PlayerBedEnterEvent e = new PlayerBedEnterEvent(p, p.getLocation().getBlock());
            Bukkit.getPluginManager().callEvent((Event)e);
            p.setAllowFlight(true);
            p.setMetadata("BedAnimation", (MetadataValue)new FixedMetadataValue(SkriptMirre.getPlugin(), (Object)true));
        }
        try {
            PacketSend.sleepAnimation(p, b, watchers);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void reset(Player p) {
        if (p.hasMetadata("BedAnimation")) {
            if (p.getGameMode() != GameMode.CREATIVE) {
                p.setAllowFlight(false);
            }
            p.removeMetadata("BedAnimation", SkriptMirre.getPlugin());
            p.setFlying(false);
        }
    }

    public static void reset(Player p, Player ... watchers) {
        try {
            PacketSend.animation(p, watchers, AnimationEnum.WAKEUP.toByte());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SleepHandler.reset(p);
    }

    public static boolean hasBedAnimation(Player p) {
        return p.hasMetadata("BedAnimation");
    }

    @EventHandler
    public void OnPlayerDeath(PlayerDeathEvent event) {
        if (SleepHandler.hasBedAnimation(event.getEntity())) {
            SleepHandler.reset(event.getEntity());
        }
    }

    @EventHandler
    public void onPlayerquit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (SleepHandler.hasBedAnimation(player)) {
            SleepHandler.reset(player);
        }
    }

    @EventHandler
    public void onPlayerkick(PlayerKickEvent event) {
        Player player = event.getPlayer();
        if (SleepHandler.hasBedAnimation(player)) {
            SleepHandler.reset(player);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (SleepHandler.hasBedAnimation(player)) {
            SleepHandler.reset(player);
        }
    }
}

