/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.beacon;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import fr.syst3ms.quarsk.classes.Registration;
import org.bukkit.Material;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SExprBeaconEffects
extends SimpleExpression<PotionEffect> {
    private Expression<Block> beacon;
    private boolean isPrimary;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, @NotNull SkriptParser.ParseResult parseResult) {
        if (parseResult == null) {
            SExprBeaconEffects.$$$reportNull$$$0(0);
        }
        this.beacon = expr[0];
        this.isPrimary = parseResult.mark == 0;
        return true;
    }

    @Nullable
    protected PotionEffect[] get(Event e) {
        Block b = (Block)this.beacon.getSingle(e);
        if (b == null) {
            return null;
        }
        if (b.getType() == Material.BEACON) {
            return new PotionEffect[]{this.isPrimary ? ((Beacon)b.getState()).getPrimaryEffect() : ((Beacon)b.getState()).getSecondaryEffect()};
        }
        return null;
    }

    public void change(Event e, Object[] delta, @NotNull Changer.ChangeMode changeMode) {
        Block b;
        if (changeMode == null) {
            SExprBeaconEffects.$$$reportNull$$$0(1);
        }
        if ((b = (Block)this.beacon.getSingle(e)) == null) {
            return;
        }
        if (b.getType() == Material.BEACON) {
            Beacon state = (Beacon)b.getState();
            switch (changeMode) {
                case SET: {
                    if (this.isPrimary) {
                        state.setPrimaryEffect((PotionEffectType)delta[0]);
                        break;
                    }
                    state.setSecondaryEffect((PotionEffectType)delta[0]);
                    break;
                }
                case DELETE: 
                case RESET: {
                    if (this.isPrimary) {
                        state.setPrimaryEffect(null);
                        break;
                    }
                    state.setSecondaryEffect(null);
                }
            }
            state.update(true, false);
        }
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE && mode != Changer.ChangeMode.REMOVE_ALL && mode != Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffectType.class});
        }
        return null;
    }

    @Nullable
    public Class<? extends PotionEffect> getReturnType() {
        return PotionEffect.class;
    }

    public boolean isSingle() {
        return true;
    }

    @Nullable
    public String toString(Event event, boolean b) {
        return (this.isPrimary ? "primary " : "secondary ") + "effect of " + this.beacon.toString(event, b);
    }

    static {
        Registration.newExpression(SExprBeaconEffects.class, PotionEffect.class, ExpressionType.COMBINED, "[the] (0\u00a6(first|primary)|1\u00a6second[ary]) [potion] effect of [beacon] %block%", "[beacon] %block%['s] (0\u00a6(first|primary)|1\u00a6second[ary]) [potion] effect");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parseResult";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeMode";
                break;
            }
        }
        objectArray2[1] = "fr/syst3ms/quarsk/expressions/beacon/SExprBeaconEffects";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "change";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

