/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.util;

import fr.syst3ms.quarsk.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.jetbrains.annotations.NotNull;

public final class BannerUtils {
    public static DyeColor colorFromMnc(char c) {
        switch (c) {
            case 'a': {
                return DyeColor.BLACK;
            }
            case 'b': {
                return DyeColor.RED;
            }
            case 'c': {
                return DyeColor.GREEN;
            }
            case 'd': {
                return DyeColor.BROWN;
            }
            case 'e': {
                return DyeColor.BLUE;
            }
            case 'f': {
                return DyeColor.PURPLE;
            }
            case 'g': {
                return DyeColor.CYAN;
            }
            case 'h': {
                return DyeColor.SILVER;
            }
            case 'i': {
                return DyeColor.GRAY;
            }
            case 'j': {
                return DyeColor.PINK;
            }
            case 'k': {
                return DyeColor.LIME;
            }
            case 'l': {
                return DyeColor.YELLOW;
            }
            case 'm': {
                return DyeColor.LIGHT_BLUE;
            }
            case 'n': {
                return DyeColor.MAGENTA;
            }
            case 'o': {
                return DyeColor.ORANGE;
            }
            case 'p': {
                return DyeColor.WHITE;
            }
        }
        return null;
    }

    public static PatternType patternTypeFromMnc(char c) {
        switch (c) {
            case 'b': {
                return PatternType.SQUARE_BOTTOM_LEFT;
            }
            case 'c': {
                return PatternType.BORDER;
            }
            case 'd': {
                return PatternType.SQUARE_BOTTOM_RIGHT;
            }
            case 'e': {
                return PatternType.BRICKS;
            }
            case 'f': {
                return PatternType.STRIPE_BOTTOM;
            }
            case 'g': {
                return PatternType.TRIANGLE_BOTTOM;
            }
            case 'h': {
                return PatternType.TRIANGLES_BOTTOM;
            }
            case 'i': {
                return PatternType.CURLY_BORDER;
            }
            case 'j': {
                return PatternType.CROSS;
            }
            case 'k': {
                return PatternType.CREEPER;
            }
            case 'l': {
                return PatternType.STRIPE_CENTER;
            }
            case 'm': {
                return PatternType.STRIPE_DOWNLEFT;
            }
            case 'n': {
                return PatternType.STRIPE_DOWNRIGHT;
            }
            case 'o': {
                return PatternType.FLOWER;
            }
            case 'p': {
                return PatternType.GRADIENT_UP;
            }
            case 'q': {
                return PatternType.HALF_HORIZONTAL;
            }
            case 'r': {
                return PatternType.DIAGONAL_LEFT;
            }
            case 's': {
                return PatternType.STRIPE_LEFT;
            }
            case 't': {
                return PatternType.CIRCLE_MIDDLE;
            }
            case 'u': {
                return PatternType.MOJANG;
            }
            case 'v': {
                return PatternType.RHOMBUS_MIDDLE;
            }
            case 'w': {
                return PatternType.STRIPE_MIDDLE;
            }
            case 'x': {
                return PatternType.DIAGONAL_RIGHT;
            }
            case 'y': {
                return PatternType.STRIPE_RIGHT;
            }
            case 'z': {
                return PatternType.STRAIGHT_CROSS;
            }
            case 'A': {
                return PatternType.SKULL;
            }
            case 'B': {
                return PatternType.STRIPE_SMALL;
            }
            case 'C': {
                return PatternType.SQUARE_TOP_LEFT;
            }
            case 'D': {
                return PatternType.SQUARE_TOP_RIGHT;
            }
            case 'E': {
                return PatternType.STRIPE_TOP;
            }
            case 'F': {
                return PatternType.TRIANGLE_TOP;
            }
            case 'G': {
                return PatternType.TRIANGLES_TOP;
            }
            case 'H': {
                return PatternType.HALF_VERTICAL;
            }
            case 'I': {
                return PatternType.DIAGONAL_LEFT_MIRROR;
            }
            case 'J': {
                return PatternType.DIAGONAL_RIGHT_MIRROR;
            }
            case 'K': {
                return PatternType.GRADIENT;
            }
            case 'L': {
                return PatternType.HALF_HORIZONTAL_MIRROR;
            }
            case 'M': {
                return PatternType.HALF_VERTICAL_MIRROR;
            }
        }
        return null;
    }

    @NotNull
    public static BannerMeta emptyBannerMeta() {
        BannerMeta bannerMeta = (BannerMeta)new ItemStack(Material.BANNER).getItemMeta();
        if (bannerMeta == null) {
            BannerUtils.$$$reportNull$$$0(0);
        }
        return bannerMeta;
    }

    public static boolean isMncPattern(@NotNull String code) {
        if (code == null) {
            BannerUtils.$$$reportNull$$$0(1);
        }
        return code.matches("[a-p]a([a-p][b-zA-M])+");
    }

    public static BannerMeta parseMncPattern(@NotNull String mnc) {
        if (mnc == null) {
            BannerUtils.$$$reportNull$$$0(2);
        }
        if (mnc.matches("[a-p]a([a-p][b-zA-M])+")) {
            List<String> groups = StringUtils.sizedSplitString(mnc, 2, true);
            BannerMeta meta = BannerUtils.emptyBannerMeta();
            meta.setBaseColor(BannerUtils.colorFromMnc(mnc.charAt(0)));
            for (String str : groups.subList(1, groups.size())) {
                if (str.isEmpty()) continue;
                meta.addPattern(new Pattern(BannerUtils.colorFromMnc(str.toCharArray()[0]), BannerUtils.patternTypeFromMnc(str.toCharArray()[1])));
            }
            return meta;
        }
        return null;
    }

    public static char colorToMnc(@NotNull DyeColor color) {
        if (color == null) {
            BannerUtils.$$$reportNull$$$0(3);
        }
        for (char c : StringUtils.alphabetLetters()) {
            if (BannerUtils.colorFromMnc(c) != color) continue;
            return c;
        }
        return '\u0000';
    }

    public static char patternTypeToMnc(@NotNull PatternType patternType) {
        if (patternType == null) {
            BannerUtils.$$$reportNull$$$0(4);
        }
        for (char c : StringUtils.alphabetLetters()) {
            if (BannerUtils.patternTypeFromMnc(c) != patternType) continue;
            return c;
        }
        return '\u0000';
    }

    public static String toMncPattern(@NotNull BannerMeta meta) {
        if (meta == null) {
            BannerUtils.$$$reportNull$$$0(5);
        }
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add(BannerUtils.colorToMnc(meta.getBaseColor()) + "a");
        for (Pattern pattern : meta.getPatterns()) {
            stringList.add(new String(new char[]{BannerUtils.colorToMnc(pattern.getColor()), BannerUtils.patternTypeToMnc(pattern.getPattern())}));
        }
        return StringUtils.join(stringList.toArray(new String[stringList.size()]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fr/syst3ms/quarsk/util/BannerUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mnc";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyBannerMeta";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fr/syst3ms/quarsk/util/BannerUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMncPattern";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseMncPattern";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "colorToMnc";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "patternTypeToMnc";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toMncPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

