/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.potion;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import fr.syst3ms.quarsk.classes.Registration;
import fr.syst3ms.quarsk.util.PotionUtils;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SExprPotionItemEffects
extends SimpleExpression<PotionEffect> {
    private Expression<ItemStack> potionItem;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.potionItem = expr[0];
        return true;
    }

    @Nullable
    protected PotionEffect[] get(Event e) {
        ItemStack i = (ItemStack)this.potionItem.getSingle(e);
        if (i == null) {
            return null;
        }
        if (PotionUtils.isPotionItem(i)) {
            PotionMeta meta = (PotionMeta)i.getItemMeta();
            return PotionUtils.actualPotionEffects(meta);
        }
        return null;
    }

    public void change(Event e, Object[] delta, @NotNull Changer.ChangeMode mode) {
        ItemStack i;
        if (mode == null) {
            SExprPotionItemEffects.$$$reportNull$$$0(0);
        }
        if ((i = (ItemStack)this.potionItem.getSingle(e)) == null) {
            return;
        }
        if (i.getType() != Material.AIR && i.getItemMeta() instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)i.getItemMeta();
            switch (mode) {
                case ADD: {
                    for (PotionEffect eff : (PotionEffect[])delta) {
                        meta.addCustomEffect(eff, true);
                    }
                    i.setItemMeta((ItemMeta)meta);
                    break;
                }
                case SET: {
                    meta.clearCustomEffects();
                    meta.setBasePotionData(PotionUtils.emptyPotionData());
                    for (PotionEffect eff : (PotionEffect[])delta) {
                        meta.addCustomEffect(eff, true);
                    }
                    i.setItemMeta((ItemMeta)meta);
                    break;
                }
                case REMOVE: 
                case REMOVE_ALL: {
                    for (PotionEffectType type : (PotionEffectType[])delta) {
                        meta.removeCustomEffect(type);
                    }
                    i.setItemMeta((ItemMeta)meta);
                    break;
                }
                case DELETE: 
                case RESET: {
                    meta.clearCustomEffects();
                    meta.setBasePotionData(PotionUtils.emptyPotionData());
                    i.setItemMeta((ItemMeta)meta);
                }
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE && mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffect[].class});
        }
        return (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffectType[].class});
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends PotionEffect> getReturnType() {
        if (PotionEffect.class == null) {
            SExprPotionItemEffects.$$$reportNull$$$0(1);
        }
        return PotionEffect.class;
    }

    @NotNull
    public String toString(Event e, boolean b) {
        String string = "potion effects on " + this.potionItem.toString(e, b);
        if (string == null) {
            SExprPotionItemEffects.$$$reportNull$$$0(2);
        }
        return string;
    }

    static {
        Registration.newExpression(SExprPotionItemEffects.class, PotionEffect.class, ExpressionType.COMBINED, "[potion] effects (on|of) %itemstack%", "%itemstack%['s] [potion] effects");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fr/syst3ms/quarsk/expressions/potion/SExprPotionItemEffects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fr/syst3ms/quarsk/expressions/potion/SExprPotionItemEffects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "change";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

