/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.PotionEffectUtils;
import fr.syst3ms.quarsk.classes.EnumType;
import fr.syst3ms.quarsk.classes.Registration;
import fr.syst3ms.quarsk.util.ReflectionUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Quarsk
extends JavaPlugin {
    private static SkriptAddon addonInstance;
    private static JavaPlugin plugin;

    public static SkriptAddon getAddon() {
        return addonInstance;
    }

    public static JavaPlugin getPlugin() {
        return plugin;
    }

    public static void debug(Object ... l) {
        Arrays.asList(l).forEach(s -> Bukkit.getLogger().log(Level.INFO, s.toString()));
    }

    public void onEnable() {
        if (!Skript.isRunningMinecraft((int)1, (int)9)) {
            this.getLogger().log(Level.INFO, "Outdated Minecraft version ! Update to 1.9 or newer !");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        plugin = this;
        this.getLogger().log(Level.INFO, "Starting up Quarsk v" + Quarsk.getPlugin().getDescription().getVersion() + " !");
        this.normalRegister();
        if (Registration.generateFolder()) {
            this.getLogger().log(Level.INFO, "Created Quarsk's folder !");
        }
        if (Registration.generateSyntaxFile()) {
            this.getLogger().log(Level.INFO, "Generated Quarsk's syntax file !");
        }
        this.getLogger().log(Level.INFO, "Registered " + Registration.getEvents().size() + " events, " + Registration.getConditions().size() + " conditions, " + Registration.getEffects().size() + " effects and " + Registration.getExpressions().size() + " expressions ! Good game !");
    }

    private int getSkriptRevision() {
        int rev;
        String postfix = (String)ReflectionUtils.getInstanceField(Skript.getVersion(), "postfix");
        if (postfix == null) {
            return -1;
        }
        Pattern pat = Pattern.compile("dev(\\d+).?");
        Matcher m = pat.matcher(postfix);
        try {
            rev = m.matches() ? Integer.parseInt(m.group(1)) : -1;
        }
        catch (NumberFormatException e) {
            rev = -1;
        }
        return rev;
    }

    private void normalRegister() {
        addonInstance = Skript.registerAddon((JavaPlugin)this).setLanguageFileDirectory("lang");
        Classes.registerClass((ClassInfo)new ClassInfo(PotionEffect.class, "potioneffect").name("potioneffect").description(new String[]{"A getter for potion effects"}).user(new String[]{"potion ?effect"}).parser((Parser)new Parser<PotionEffect>(){

            @com.sun.istack.internal.Nullable
            public PotionEffect parse(String obj, ParseContext context) {
                return null;
            }

            @NotNull
            public String toString(@NotNull PotionEffect potionEffect, int i) {
                if (potionEffect == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = PotionEffectUtils.toString((PotionEffectType)potionEffect.getType()) + " of tier " + potionEffect.getAmplifier() + " lasting " + potionEffect.getDuration() + " with particles " + (potionEffect.hasParticles() ? "enabled" : "disabled") + ", ambient effect " + (potionEffect.isAmbient() ? "enabled" : "disabled");
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String toVariableNameString(@NotNull PotionEffect potionEffect) {
                if (potionEffect == null) {
                    1.$$$reportNull$$$0(2);
                }
                String string = potionEffect.getType().toString().toLowerCase() + "," + potionEffect.getAmplifier() + "," + potionEffect.getDuration() + "," + potionEffect.hasParticles() + "," + potionEffect.isAmbient() + "," + potionEffect.getColor().toString().toLowerCase();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            public String getVariableNamePattern() {
                if ("[a-z]+,\\d+,\\d+,(true|false),(true|false),[a-z]+" == null) {
                    1.$$$reportNull$$$0(4);
                }
                return "[a-z]+,\\d+,\\d+,(true|false),(true|false),[a-z]+";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "potionEffect";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fr/syst3ms/quarsk/Quarsk$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fr/syst3ms/quarsk/Quarsk$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toString";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toVariableNameString";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariableNamePattern";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "toString";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "toVariableNameString";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(org.bukkit.block.banner.Pattern.class, "bannerlayer").name("banner layer").description(new String[]{"A getter for banner layers"}).user(new String[]{"banner ?(layer|pattern)"}).parser((Parser)new Parser<org.bukkit.block.banner.Pattern>(){

            @Nullable
            public org.bukkit.block.banner.Pattern parse(String s, ParseContext parseContext) {
                return null;
            }

            @NotNull
            public String toString(@NotNull org.bukkit.block.banner.Pattern pattern, int i) {
                if (pattern == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = "layer with pattern " + EnumType.toString(pattern.getPattern().name()) + " and color " + pattern.getColor().toString().toLowerCase();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String toVariableNameString(@NotNull org.bukkit.block.banner.Pattern pattern) {
                if (pattern == null) {
                    2.$$$reportNull$$$0(2);
                }
                String string = "bannerlayer," + pattern.getPattern().toString().toLowerCase() + "," + pattern.getColor().toString().toLowerCase();
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            public String getVariableNamePattern() {
                if ("bannerlayer,[a-z]+,[a-z]+" == null) {
                    2.$$$reportNull$$$0(4);
                }
                return "bannerlayer,[a-z]+,[a-z]+";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fr/syst3ms/quarsk/Quarsk$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fr/syst3ms/quarsk/Quarsk$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toString";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toVariableNameString";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariableNamePattern";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "toString";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "toVariableNameString";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }));
        EnumType.newType(PatternType.class, "bannerpattern", "banner ?pattern(?: ?type)?");
        EventValues.registerEventValue(PotionSplashEvent.class, Projectile.class, (Getter)new Getter<Projectile, PotionSplashEvent>(){

            public Projectile get(PotionSplashEvent potionSplashEvent) {
                return potionSplashEvent.getEntity();
            }
        }, (int)0);
        EventValues.registerEventValue(LingeringPotionSplashEvent.class, Projectile.class, (Getter)new Getter<Projectile, LingeringPotionSplashEvent>(){

            public Projectile get(LingeringPotionSplashEvent lingeringPotionSplashEvent) {
                return lingeringPotionSplashEvent.getEntity();
            }
        }, (int)0);
        EventValues.registerEventValue(LingeringPotionSplashEvent.class, Entity.class, (Getter)new Getter<Entity, LingeringPotionSplashEvent>(){

            public Entity get(LingeringPotionSplashEvent lingeringPotionSplashEvent) {
                return lingeringPotionSplashEvent.getEntity();
            }
        }, (int)0);
        try {
            Quarsk.getAddon().loadClasses("fr.syst3ms.quarsk", new String[]{"conditions", "effects", "events", "expressions"});
            Quarsk.getAddon().loadClasses("fr.syst3ms.quarsk.effects", new String[]{"banner", "potion"});
            Quarsk.getAddon().loadClasses("fr.syst3ms.quarsk.expressions", new String[]{"banner", "beacon", "eventvalues", "potion"});
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, (String[])new String[]{"An error has occured while registering Quarsk's syntax", "Report this error to me, Syst3ms, and I will (hopefully) fix it"});
        }
    }

    public void onDisable() {
    }
}

