/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.potion;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import fr.syst3ms.quarsk.classes.Registration;
import fr.syst3ms.quarsk.util.PotionUtils;
import java.util.Arrays;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SExprThrownPotionEffects
extends SimpleExpression<PotionEffect> {
    private Expression<Entity> entity;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.entity = expr[0];
        return true;
    }

    @Nullable
    protected PotionEffect[] get(Event e) {
        Entity ent = (Entity)this.entity.getSingle(e);
        if (ent == null) {
            return null;
        }
        if (ent instanceof ThrownPotion) {
            return (PotionEffect[])((ThrownPotion)ent).getEffects().stream().toArray(PotionEffect[]::new);
        }
        if (ent instanceof TippedArrow) {
            return (PotionEffect[])((TippedArrow)ent).getCustomEffects().stream().toArray(PotionEffect[]::new);
        }
        return null;
    }

    public void change(Event e, Object[] delta, @NotNull Changer.ChangeMode mode) {
        Entity ent;
        if (mode == null) {
            SExprThrownPotionEffects.$$$reportNull$$$0(0);
        }
        if ((ent = (Entity)this.entity.getSingle(e)) == null) {
            return;
        }
        if (PotionUtils.isEntityThrownPotion(ent)) {
            ItemStack item = ((ThrownPotion)ent).getItem();
            PotionMeta potionMeta = (PotionMeta)((ThrownPotion)ent).getItem().getItemMeta();
            switch (mode) {
                case ADD: {
                    Arrays.asList((PotionEffect[])delta).forEach(eff -> potionMeta.addCustomEffect(eff, true));
                    break;
                }
                case SET: {
                    potionMeta.clearCustomEffects();
                    Arrays.asList((PotionEffect[])delta).forEach(eff -> potionMeta.addCustomEffect(eff, true));
                    break;
                }
                case REMOVE: {
                    potionMeta.removeCustomEffect((PotionEffectType)delta[0]);
                    break;
                }
                case DELETE: {
                    potionMeta.clearCustomEffects();
                }
            }
            item.setItemMeta((ItemMeta)potionMeta);
            ((ThrownPotion)ent).setItem(item);
        } else if (ent.getType() == EntityType.TIPPED_ARROW) {
            TippedArrow tippedArrow = (TippedArrow)ent;
            switch (mode) {
                case ADD: {
                    Arrays.asList((PotionEffect[])delta).forEach(eff -> tippedArrow.addCustomEffect(eff, true));
                    break;
                }
                case SET: {
                    tippedArrow.clearCustomEffects();
                    Arrays.asList((PotionEffect[])delta).forEach(eff -> tippedArrow.addCustomEffect(eff, true));
                    break;
                }
                case REMOVE: {
                    tippedArrow.removeCustomEffect((PotionEffectType)delta[0]);
                    break;
                }
                case DELETE: {
                    tippedArrow.clearCustomEffects();
                }
            }
        }
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffectType.class});
        }
        if (mode != Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffect[].class});
        }
        return null;
    }

    @NotNull
    public Class<? extends PotionEffect> getReturnType() {
        if (PotionEffect.class == null) {
            SExprThrownPotionEffects.$$$reportNull$$$0(1);
        }
        return PotionEffect.class;
    }

    public boolean isSingle() {
        return false;
    }

    public String toString(Event event, boolean b) {
        return "potion effects on " + this.entity.toString(event, b);
    }

    static {
        Registration.newExpression(SExprThrownPotionEffects.class, PotionEffect.class, ExpressionType.COMBINED, "[all] [potion] effects (of|on) [(entity|thrown potion|tipped arrow)] %entity%");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fr/syst3ms/quarsk/expressions/potion/SExprThrownPotionEffects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fr/syst3ms/quarsk/expressions/potion/SExprThrownPotionEffects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "change";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

