/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.potion;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import fr.syst3ms.quarsk.classes.Registration;
import fr.syst3ms.quarsk.util.PotionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SExprItemEffectTypeAmplifier
extends SimpleExpression<Number> {
    private Expression<PotionEffectType> effectType;
    private Expression<ItemStack> item;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.effectType = expr[0];
        this.item = expr[1];
        return true;
    }

    @Nullable
    protected Number[] get(Event e) {
        ItemStack i = (ItemStack)this.item.getSingle(e);
        if (i == null) {
            return null;
        }
        if (PotionUtils.isPotionItem(i)) {
            PotionMeta meta = (PotionMeta)i.getItemMeta();
            PotionEffect eff = PotionUtils.getEffectByEffectType(meta, (PotionEffectType)this.effectType.getSingle(e));
            if (eff == null) {
                return null;
            }
            return new Number[]{eff.getAmplifier()};
        }
        return null;
    }

    public void change(Event e, Object[] delta, @NotNull Changer.ChangeMode mode) {
        ItemStack i;
        if (mode == null) {
            SExprItemEffectTypeAmplifier.$$$reportNull$$$0(0);
        }
        if ((i = (ItemStack)this.item.getSingle(e)) == null) {
            return;
        }
        if (PotionUtils.isPotionItem(i)) {
            PotionEffect potionEffect;
            PotionMeta meta = (PotionMeta)i.getItemMeta();
            PotionEffect potionEffect2 = potionEffect = meta.getBasePotionData().getType() != PotionType.UNCRAFTABLE ? PotionUtils.getEffectByEffectType(meta, (PotionEffectType)this.effectType.getSingle(e)) : PotionUtils.fromPotionData(meta.getBasePotionData());
            if (potionEffect == null) {
                return;
            }
            if (meta.getBasePotionData().getType() != PotionType.UNCRAFTABLE) {
                meta.removeCustomEffect((PotionEffectType)this.effectType.getSingle(e));
            } else {
                meta.setBasePotionData(PotionUtils.emptyPotionData());
            }
            Number number = (Number)delta[0];
            switch (mode) {
                case ADD: {
                    meta.addCustomEffect(new PotionEffect(potionEffect.getType(), potionEffect.getDuration(), potionEffect.getAmplifier() + number.intValue(), potionEffect.isAmbient(), potionEffect.hasParticles(), potionEffect.getColor()), true);
                    break;
                }
                case SET: {
                    meta.addCustomEffect(new PotionEffect(potionEffect.getType(), potionEffect.getDuration(), number.intValue(), potionEffect.isAmbient(), potionEffect.hasParticles(), potionEffect.getColor()), true);
                    break;
                }
                case REMOVE: {
                    meta.addCustomEffect(new PotionEffect(potionEffect.getType(), potionEffect.getDuration(), potionEffect.getAmplifier() - number.intValue() > 0 ? potionEffect.getAmplifier() - number.intValue() : potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles(), potionEffect.getColor()), true);
                }
            }
        }
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL && mode != Changer.ChangeMode.RESET && mode != Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        if (Number.class == null) {
            SExprItemEffectTypeAmplifier.$$$reportNull$$$0(1);
        }
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean b) {
        return "tier of " + this.effectType.toString(event, b) + " on " + this.item.toString(event, b);
    }

    static {
        Registration.newExpression(SExprItemEffectTypeAmplifier.class, Number.class, ExpressionType.COMBINED, "(tier|amplifier) of %potioneffecttype% on %itemstack%", "%potioneffecttype%['s] (tier|amplifier) on %itemstack%");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fr/syst3ms/quarsk/expressions/potion/SExprItemEffectTypeAmplifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fr/syst3ms/quarsk/expressions/potion/SExprItemEffectTypeAmplifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "change";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

