/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.util;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public final class PotionUtils {
    public static PotionEffect getEffectByEffectType(@NotNull PotionMeta meta, PotionEffectType effectType) {
        if (meta == null) {
            PotionUtils.$$$reportNull$$$0(0);
        }
        List effectList = meta.getCustomEffects();
        return effectList.stream().filter(effect -> effect.getType() == effectType).findFirst().orElse(null);
    }

    public static boolean isPotionItem(@NotNull ItemStack item) {
        if (item == null) {
            PotionUtils.$$$reportNull$$$0(1);
        }
        return item.getType() == Material.POTION || item.getType() == Material.SPLASH_POTION || item.getType() == Material.LINGERING_POTION || item.getType() == Material.TIPPED_ARROW;
    }

    @NotNull
    public static PotionEffect fromPotionData(@NotNull PotionData data) {
        PotionEffectType type;
        if (data == null) {
            PotionUtils.$$$reportNull$$$0(2);
        }
        if ((type = data.getType().getEffectType()) == PotionEffectType.HEAL || type == PotionEffectType.HARM) {
            PotionEffect potionEffect = new PotionEffect(type, 1, data.isUpgraded() ? 2 : 1);
            if (potionEffect == null) {
                PotionUtils.$$$reportNull$$$0(3);
            }
            return potionEffect;
        }
        if (type == PotionEffectType.REGENERATION || type == PotionEffectType.POISON) {
            if (data.isExtended()) {
                PotionEffect potionEffect = new PotionEffect(type, 1800, 1);
                if (potionEffect == null) {
                    PotionUtils.$$$reportNull$$$0(4);
                }
                return potionEffect;
            }
            if (data.isUpgraded()) {
                PotionEffect potionEffect = new PotionEffect(type, 440, 2);
                if (potionEffect == null) {
                    PotionUtils.$$$reportNull$$$0(5);
                }
                return potionEffect;
            }
            PotionEffect potionEffect = new PotionEffect(type, 900, 1);
            if (potionEffect == null) {
                PotionUtils.$$$reportNull$$$0(6);
            }
            return potionEffect;
        }
        if (type == PotionEffectType.NIGHT_VISION || type == PotionEffectType.INVISIBILITY || type == PotionEffectType.FIRE_RESISTANCE || type == PotionEffectType.WATER_BREATHING) {
            PotionEffect potionEffect = new PotionEffect(type, data.isExtended() ? 9600 : 3600, 1);
            if (potionEffect == null) {
                PotionUtils.$$$reportNull$$$0(7);
            }
            return potionEffect;
        }
        if (type == PotionEffectType.WEAKNESS || type == PotionEffectType.SLOW) {
            PotionEffect potionEffect = new PotionEffect(type, data.isExtended() ? 4800 : 1800, 1);
            if (potionEffect == null) {
                PotionUtils.$$$reportNull$$$0(8);
            }
            return potionEffect;
        }
        if (data.isExtended()) {
            PotionEffect potionEffect = new PotionEffect(type, 9600, 1);
            if (potionEffect == null) {
                PotionUtils.$$$reportNull$$$0(9);
            }
            return potionEffect;
        }
        if (data.isUpgraded()) {
            PotionEffect potionEffect = new PotionEffect(type, 1800, 2);
            if (potionEffect == null) {
                PotionUtils.$$$reportNull$$$0(10);
            }
            return potionEffect;
        }
        PotionEffect potionEffect = new PotionEffect(type, 3600, 1);
        if (potionEffect == null) {
            PotionUtils.$$$reportNull$$$0(11);
        }
        return potionEffect;
    }

    @NotNull
    public static PotionData emptyPotionData() {
        PotionData potionData = new PotionData(PotionType.WATER);
        if (potionData == null) {
            PotionUtils.$$$reportNull$$$0(12);
        }
        return potionData;
    }

    public static boolean isEntityThrownPotion(@NotNull Entity entity) {
        if (entity == null) {
            PotionUtils.$$$reportNull$$$0(13);
        }
        return entity.getType() == EntityType.SPLASH_POTION || entity.getType() == EntityType.LINGERING_POTION;
    }

    public static PotionEffect[] actualPotionEffects(@NotNull PotionMeta meta) {
        if (meta == null) {
            PotionUtils.$$$reportNull$$$0(14);
        }
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        effects.addAll(meta.getCustomEffects());
        if (meta.getBasePotionData().getType() != PotionType.UNCRAFTABLE) {
            effects.add(PotionUtils.fromPotionData(meta.getBasePotionData()));
        }
        return effects.toArray(new PotionEffect[effects.size()]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fr/syst3ms/quarsk/util/PotionUtils";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fr/syst3ms/quarsk/util/PotionUtils";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromPotionData";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyPotionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEffectByEffectType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPotionItem";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromPotionData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEntityThrownPotion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "actualPotionEffects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

