/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.potion;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import fr.syst3ms.quarsk.classes.EnumType;
import fr.syst3ms.quarsk.classes.Registration;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public class ExprCustomPotionItem
extends SimpleExpression<ItemStack> {
    private Material material;
    private Expression<PotionEffect> potionEffects;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, @NotNull SkriptParser.ParseResult parseResult) {
        if (parseResult == null) {
            ExprCustomPotionItem.$$$reportNull$$$0(0);
        }
        switch (parseResult.mark) {
            case 0: {
                this.material = Material.POTION;
                break;
            }
            case 1: {
                this.material = Material.SPLASH_POTION;
                break;
            }
            case 2: {
                this.material = Material.LINGERING_POTION;
                break;
            }
            case 3: {
                this.material = Material.TIPPED_ARROW;
                break;
            }
            default: {
                this.material = Material.POTION;
            }
        }
        this.potionEffects = expr[0];
        return true;
    }

    @NotNull
    protected ItemStack[] get(Event e) {
        ItemStack item = new ItemStack(this.material, 1);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        Stream.of(this.potionEffects.getAll(e)).forEach(eff -> meta.addCustomEffect(eff, true));
        item.setItemMeta((ItemMeta)meta);
        ItemStack[] itemStackArray = new ItemStack[]{item};
        if (itemStackArray == null) {
            ExprCustomPotionItem.$$$reportNull$$$0(1);
        }
        return itemStackArray;
    }

    @NotNull
    public Class getReturnType() {
        if (ItemStack.class == null) {
            ExprCustomPotionItem.$$$reportNull$$$0(2);
        }
        return ItemStack.class;
    }

    @NotNull
    public String toString(Event event, boolean b) {
        String string = EnumType.toString(this.material.name()) + " using effects " + this.potionEffects.toString(event, b);
        if (string == null) {
            ExprCustomPotionItem.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isSingle() {
        return true;
    }

    static {
        Registration.newExpression(ExprCustomPotionItem.class, ItemStack.class, ExpressionType.COMBINED, "(0\u00a6[normal] potion|1\u00a6splash potion|2\u00a6linger[ing] potion|3\u00a6(potion|tipped) arrow) (with|using) [effects] %potioneffects%");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parseResult";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fr/syst3ms/quarsk/expressions/potion/ExprCustomPotionItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fr/syst3ms/quarsk/expressions/potion/ExprCustomPotionItem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

