/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.classes;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.registrations.Classes;
import com.google.common.collect.ImmutableSet;
import fr.syst3ms.quarsk.QuarSk;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class Registration {
    @NotNull
    private static Set<QuarskExpressionInfo> expressions = new HashSet<QuarskExpressionInfo>();
    @NotNull
    private static Set<QuarskSyntaxInfo> effects = new HashSet<QuarskSyntaxInfo>();
    @NotNull
    private static Set<QuarskSyntaxInfo> conditions = new HashSet<QuarskSyntaxInfo>();
    @NotNull
    private static Set<QuarskSyntaxInfo> events = new HashSet<QuarskSyntaxInfo>();

    public static <E extends Expression<T>, T> void newExpression(@NotNull Class<E> clazz, @NotNull Class<T> returnType, @NotNull ExpressionType type, String ... syntaxes) {
        if (clazz == null) {
            Registration.$$$reportNull$$$0(0);
        }
        if (returnType == null) {
            Registration.$$$reportNull$$$0(1);
        }
        if (type == null) {
            Registration.$$$reportNull$$$0(2);
        }
        Skript.registerExpression(clazz, returnType, (ExpressionType)type, (String[])Registration.prefixEachString(Registration.getSyntaxPrefix(), syntaxes));
        expressions.add(new QuarskExpressionInfo(returnType, syntaxes));
    }

    public static <E extends PropertyExpression<?, T>, T> void newPropertyExpression(@NotNull Class<E> clazz, @NotNull Class<T> returnType, String property, String type) {
        if (clazz == null) {
            Registration.$$$reportNull$$$0(3);
        }
        if (returnType == null) {
            Registration.$$$reportNull$$$0(4);
        }
        String first = String.format("[the] %s of %%%s%%", property, type);
        String second = String.format("%%%s%%'[s] %s", type, property);
        Skript.registerExpression(clazz, returnType, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{first, second});
        expressions.add(new QuarskExpressionInfo(returnType, first, second));
    }

    public static <E extends Effect> void newEffect(@NotNull Class<E> clazz, String ... syntaxes) {
        if (clazz == null) {
            Registration.$$$reportNull$$$0(5);
        }
        Skript.registerEffect(clazz, (String[])Registration.prefixEachString(Registration.getSyntaxPrefix(), syntaxes));
        effects.add(new QuarskSyntaxInfo(syntaxes));
    }

    public static <C extends Condition> void newCondition(@NotNull Class<C> clazz, String ... syntaxes) {
        if (clazz == null) {
            Registration.$$$reportNull$$$0(6);
        }
        Skript.registerCondition(clazz, (String[])Registration.prefixEachString(Registration.getSyntaxPrefix(), syntaxes));
        conditions.add(new QuarskSyntaxInfo(syntaxes));
    }

    public static <C extends PropertyCondition> void newPropertyCondition(@NotNull Class<C> clazz, String property, String type) {
        if (clazz == null) {
            Registration.$$$reportNull$$$0(7);
        }
        String first = String.format("%%%s%% (is|are) %s", type, property);
        String second = String.format("%%%s%% (isn't|is not|aren't|are not) %s", type, property);
        Skript.registerCondition(clazz, (String[])new String[]{first, second});
        conditions.add(new QuarskSyntaxInfo(first, second));
    }

    public static <E extends SkriptEvent> void newEvent(String name, Class<E> skriptEvent, Class<? extends Event> event, String ... syntaxes) {
        Skript.registerEvent((String)name, skriptEvent, event, (String[])Registration.prefixEachString(Registration.getSyntaxPrefix(), syntaxes));
        events.add(new QuarskSyntaxInfo(syntaxes));
    }

    public static String getSyntaxPrefix() {
        return "[quar[s]k] ";
    }

    public static String[] prefixEachString(String prefix, String ... strings) {
        return (String[])Stream.of(strings).map(s -> prefix + s).toArray(String[]::new);
    }

    public static boolean generateFolder() {
        return !QuarSk.getPlugin().getDataFolder().exists() && QuarSk.getPlugin().getDataFolder().mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean generateSyntaxFile() {
        BufferedWriter fileWriter;
        File syntaxFile = new File(((QuarSk)JavaPlugin.getPlugin(QuarSk.class)).getDataFolder(), "syntax.txt");
        if (!syntaxFile.exists()) {
            try {
                syntaxFile.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
        } else {
            syntaxFile.delete();
        }
        try {
            fileWriter = new BufferedWriter(new FileWriter(syntaxFile));
        }
        catch (IOException e) {
            return false;
        }
        Registration.writeLine(fileWriter, "Notice : All syntax is inherently prefixed with '[quar[s]k]'");
        fileWriter.newLine();
        Registration.writeLine(fileWriter, "Events :");
        for (String s : events.stream().flatMap(i -> i.getPatterns().stream()).collect(Collectors.toList())) {
            Registration.writeLine(fileWriter, "  - " + s);
        }
        Registration.writeLine(fileWriter, "Conditions :");
        for (String s : conditions.stream().flatMap(i -> i.getPatterns().stream()).collect(Collectors.toList())) {
            Registration.writeLine(fileWriter, "  - " + s);
        }
        Registration.writeLine(fileWriter, "Effects :");
        for (String s : effects.stream().flatMap(i -> i.getPatterns().stream()).collect(Collectors.toList())) {
            Registration.writeLine(fileWriter, "  - " + s);
        }
        Registration.writeLine(fileWriter, "Expressions :");
        for (QuarskExpressionInfo info : expressions) {
            for (String s : info.getPatterns()) {
                Registration.writeLine(fileWriter, "  - " + s + " >> returns a(n) " + Classes.getExactClassInfo(info.getReturnType()).getName().withIndefiniteArticle());
            }
        }
        boolean e = true;
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            Skript.exception((Throwable)e2, (String[])new String[]{"Honestly dunno how that happened"});
        }
        return e;
        catch (IOException e2) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                try {
                    fileWriter.close();
                }
                catch (IOException e3) {
                    Skript.exception((Throwable)e3, (String[])new String[]{"Honestly dunno how that happened"});
                }
                throw throwable;
            }
            try {
                fileWriter.close();
            }
            catch (IOException e4) {
                Skript.exception((Throwable)e4, (String[])new String[]{"Honestly dunno how that happened"});
            }
            return bl;
        }
    }

    public static void writeLine(@NotNull BufferedWriter writer, @NotNull String s) throws IOException {
        if (writer == null) {
            Registration.$$$reportNull$$$0(8);
        }
        if (s == null) {
            Registration.$$$reportNull$$$0(9);
        }
        writer.write(s);
        writer.newLine();
    }

    public static Set<QuarskSyntaxInfo> getExpressions() {
        return ImmutableSet.copyOf(expressions);
    }

    public static Set<QuarskSyntaxInfo> getEffects() {
        return ImmutableSet.copyOf(effects);
    }

    public static Set<QuarskSyntaxInfo> getConditions() {
        return ImmutableSet.copyOf(conditions);
    }

    public static Set<QuarskSyntaxInfo> getEvents() {
        return ImmutableSet.copyOf(events);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "fr/syst3ms/quarsk/classes/Registration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newExpression";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "newPropertyExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "newEffect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "newCondition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "newPropertyCondition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class QuarskExpressionInfo
    extends QuarskSyntaxInfo {
        private final Class<?> returnType;

        public QuarskExpressionInfo(Class<?> returnType, String ... patterns) {
            super(patterns);
            this.returnType = returnType;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }
    }

    public static class QuarskSyntaxInfo {
        private final List<String> patterns;

        public QuarskSyntaxInfo(String ... patterns) {
            this.patterns = Stream.of(patterns).map(s -> s.replaceAll("(?<=%)(-[~*]|[~*])", "").replaceAll("(?<=[(|])\\d+?\u00a6", "").replaceAll("@-?1(?=%)", "")).collect(Collectors.toList());
        }

        public List<String> getPatterns() {
            return this.patterns;
        }
    }
}

