/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.util;

import fr.syst3ms.quarsk.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;

public class BannerUtils {
    private static BannerUtils instance = new BannerUtils();

    public static BannerUtils getInstance() {
        return instance;
    }

    public DyeColor colorFromMnc(char c) {
        switch (c) {
            case 'a': {
                return DyeColor.BLACK;
            }
            case 'b': {
                return DyeColor.RED;
            }
            case 'c': {
                return DyeColor.GREEN;
            }
            case 'd': {
                return DyeColor.BROWN;
            }
            case 'e': {
                return DyeColor.BLUE;
            }
            case 'f': {
                return DyeColor.PURPLE;
            }
            case 'g': {
                return DyeColor.CYAN;
            }
            case 'h': {
                return DyeColor.SILVER;
            }
            case 'i': {
                return DyeColor.GRAY;
            }
            case 'j': {
                return DyeColor.PINK;
            }
            case 'k': {
                return DyeColor.LIME;
            }
            case 'l': {
                return DyeColor.YELLOW;
            }
            case 'm': {
                return DyeColor.LIGHT_BLUE;
            }
            case 'n': {
                return DyeColor.MAGENTA;
            }
            case 'o': {
                return DyeColor.ORANGE;
            }
            case 'p': {
                return DyeColor.WHITE;
            }
        }
        return null;
    }

    public PatternType patternTypeFromMnc(char c) {
        switch (c) {
            case 'b': {
                return PatternType.SQUARE_BOTTOM_LEFT;
            }
            case 'c': {
                return PatternType.BORDER;
            }
            case 'd': {
                return PatternType.SQUARE_BOTTOM_RIGHT;
            }
            case 'e': {
                return PatternType.BRICKS;
            }
            case 'f': {
                return PatternType.STRIPE_BOTTOM;
            }
            case 'g': {
                return PatternType.TRIANGLE_BOTTOM;
            }
            case 'h': {
                return PatternType.TRIANGLES_BOTTOM;
            }
            case 'i': {
                return PatternType.CURLY_BORDER;
            }
            case 'j': {
                return PatternType.CROSS;
            }
            case 'k': {
                return PatternType.CREEPER;
            }
            case 'l': {
                return PatternType.STRIPE_CENTER;
            }
            case 'm': {
                return PatternType.STRIPE_DOWNLEFT;
            }
            case 'n': {
                return PatternType.STRIPE_DOWNRIGHT;
            }
            case 'o': {
                return PatternType.FLOWER;
            }
            case 'p': {
                return PatternType.GRADIENT_UP;
            }
            case 'q': {
                return PatternType.HALF_HORIZONTAL;
            }
            case 'r': {
                return PatternType.DIAGONAL_LEFT;
            }
            case 's': {
                return PatternType.STRIPE_LEFT;
            }
            case 't': {
                return PatternType.CIRCLE_MIDDLE;
            }
            case 'u': {
                return PatternType.MOJANG;
            }
            case 'v': {
                return PatternType.RHOMBUS_MIDDLE;
            }
            case 'w': {
                return PatternType.STRIPE_MIDDLE;
            }
            case 'x': {
                return PatternType.DIAGONAL_RIGHT;
            }
            case 'y': {
                return PatternType.STRIPE_RIGHT;
            }
            case 'z': {
                return PatternType.STRAIGHT_CROSS;
            }
            case 'A': {
                return PatternType.SKULL;
            }
            case 'B': {
                return PatternType.STRIPE_SMALL;
            }
            case 'C': {
                return PatternType.SQUARE_TOP_LEFT;
            }
            case 'D': {
                return PatternType.SQUARE_TOP_RIGHT;
            }
            case 'E': {
                return PatternType.STRIPE_TOP;
            }
            case 'F': {
                return PatternType.TRIANGLE_TOP;
            }
            case 'G': {
                return PatternType.TRIANGLES_TOP;
            }
            case 'H': {
                return PatternType.HALF_VERTICAL;
            }
            case 'I': {
                return PatternType.DIAGONAL_LEFT_MIRROR;
            }
            case 'J': {
                return PatternType.DIAGONAL_RIGHT_MIRROR;
            }
            case 'K': {
                return PatternType.GRADIENT;
            }
            case 'L': {
                return PatternType.HALF_HORIZONTAL_MIRROR;
            }
            case 'M': {
                return PatternType.HALF_VERTICAL_MIRROR;
            }
        }
        return null;
    }

    public BannerMeta emptyBannerMeta() {
        return (BannerMeta)new ItemStack(Material.BANNER).getItemMeta();
    }

    public boolean isMncPattern(String code) {
        return code.matches("[a-p]a([a-p][b-zA-M])+");
    }

    public BannerMeta parseMncPattern(String mnc) {
        if (mnc.matches("[a-p]a([a-p][b-zA-M])+")) {
            List<String> groups = StringUtils.getInstance().sizedSplitString(mnc, 2, true);
            BannerMeta meta = this.emptyBannerMeta();
            meta.setBaseColor(this.colorFromMnc(mnc.charAt(0)));
            for (String str : groups.subList(1, groups.size())) {
                if (str.isEmpty()) continue;
                meta.addPattern(new Pattern(this.colorFromMnc(str.toCharArray()[0]), this.patternTypeFromMnc(str.toCharArray()[1])));
            }
            return meta;
        }
        return null;
    }

    public char colorToMnc(DyeColor color) {
        for (char c : StringUtils.getInstance().alphabetLetters()) {
            if (this.colorFromMnc(c) != color) continue;
            return c;
        }
        return '\u0000';
    }

    public char patternTypeToMnc(PatternType patternType) {
        for (char c : StringUtils.getInstance().alphabetLetters()) {
            if (this.patternTypeFromMnc(c) != patternType) continue;
            return c;
        }
        return '\u0000';
    }

    public String toMncPattern(BannerMeta meta) {
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add(this.colorToMnc(meta.getBaseColor()) + "a");
        for (Pattern pattern : meta.getPatterns()) {
            stringList.add(new String(new char[]{this.colorToMnc(pattern.getColor()), this.patternTypeToMnc(pattern.getPattern())}));
        }
        return StringUtils.getInstance().join(stringList.toArray(new String[stringList.size()]));
    }
}

