/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.potion;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import fr.syst3ms.quarsk.util.PotionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SExprThrownPotionEffects
extends SimpleExpression<PotionEffect> {
    private Expression<Entity> entity;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.entity = expr[0];
        return true;
    }

    protected PotionEffect[] get(Event e) {
        if (this.entity != null && this.entity.getSingle(e) != null) {
            if (this.entity.getSingle(e) instanceof ThrownPotion) {
                ThrownPotion thrownPotion = (ThrownPotion)this.entity.getSingle(e);
                return thrownPotion.getEffects().toArray(new PotionEffect[thrownPotion.getEffects().size()]);
            }
            if (this.entity.getSingle(e) instanceof TippedArrow) {
                TippedArrow tippedArrow = (TippedArrow)this.entity.getSingle(e);
                return tippedArrow.getCustomEffects().toArray(new PotionEffect[tippedArrow.getCustomEffects().size()]);
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.entity != null) {
            if (PotionUtils.getInstance().isEntityThrownPotion((Entity)this.entity.getSingle(e))) {
                ItemStack item = ((ThrownPotion)this.entity.getSingle(e)).getItem();
                PotionMeta potionMeta = (PotionMeta)((ThrownPotion)this.entity.getSingle(e)).getItem().getItemMeta();
                switch (mode) {
                    case ADD: {
                        if (!(delta[0] instanceof PotionEffect)) break;
                        for (PotionEffect effect : (PotionEffect[])delta) {
                            potionMeta.addCustomEffect(effect, true);
                        }
                        break;
                    }
                    case SET: {
                        if (!(delta[0] instanceof PotionEffect)) break;
                        potionMeta.clearCustomEffects();
                        for (PotionEffect effect : (PotionEffect[])delta) {
                            potionMeta.addCustomEffect(effect, true);
                        }
                        break;
                    }
                    case REMOVE: {
                        if (!(delta[0] instanceof PotionEffectType)) break;
                        potionMeta.removeCustomEffect((PotionEffectType)delta[0]);
                        break;
                    }
                    case DELETE: {
                        potionMeta.clearCustomEffects();
                    }
                }
                item.setItemMeta((ItemMeta)potionMeta);
                ((ThrownPotion)this.entity.getSingle(e)).setItem(item);
            } else if (((Entity)this.entity.getSingle(e)).getType() == EntityType.TIPPED_ARROW) {
                TippedArrow tippedArrow = (TippedArrow)this.entity.getSingle(e);
                switch (mode) {
                    case ADD: {
                        if (!(delta[0] instanceof PotionEffect)) break;
                        for (PotionEffect effect : (PotionEffect[])delta) {
                            tippedArrow.addCustomEffect(effect, true);
                        }
                        break;
                    }
                    case SET: {
                        if (!(delta[0] instanceof PotionEffect)) break;
                        tippedArrow.clearCustomEffects();
                        for (PotionEffect effect : (PotionEffect[])delta) {
                            tippedArrow.addCustomEffect(effect, true);
                        }
                        break;
                    }
                    case REMOVE: {
                        if (!(delta[0] instanceof PotionEffectType)) break;
                        tippedArrow.removeCustomEffect((PotionEffectType)delta[0]);
                        break;
                    }
                    case DELETE: {
                        tippedArrow.clearCustomEffects();
                    }
                }
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffectType.class});
        }
        if (mode != Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffect[].class});
        }
        return null;
    }

    public Class<? extends PotionEffect> getReturnType() {
        return PotionEffect.class;
    }

    public boolean isSingle() {
        return false;
    }

    public String toString(Event event, boolean b) {
        return ((Object)((Object)this)).getClass().getName();
    }
}

