/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.potion;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import fr.syst3ms.quarsk.util.PotionUtils;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class SExprPotionItemEffects
extends SimpleExpression<PotionEffect> {
    private Expression<ItemStack> potionItem;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.potionItem = expr[0];
        return true;
    }

    protected PotionEffect[] get(Event e) {
        if (this.potionItem != null && this.potionItem.getSingle(e) != null && PotionUtils.getInstance().isPotionItem((ItemStack)this.potionItem.getSingle(e))) {
            PotionMeta meta = (PotionMeta)((ItemStack)this.potionItem.getSingle(e)).getItemMeta();
            ArrayList<PotionEffect> list = new ArrayList<PotionEffect>();
            if (meta.getBasePotionData().getType() != PotionType.UNCRAFTABLE) {
                list.add(PotionUtils.getInstance().fromPotionData(meta.getBasePotionData()));
            }
            for (PotionEffect eff : meta.getCustomEffects()) {
                list.add(eff);
            }
            return list.toArray(new PotionEffect[meta.getCustomEffects().size() + (meta.getBasePotionData().getType() != PotionType.UNCRAFTABLE ? 1 : 0)]);
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.potionItem != null && this.potionItem.getSingle(e) != null && ((ItemStack)this.potionItem.getSingle(e)).getType() != Material.AIR && ((ItemStack)this.potionItem.getSingle(e)).getItemMeta() instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)((ItemStack)this.potionItem.getSingle(e)).getItemMeta();
            switch (mode) {
                case ADD: {
                    for (Object o : delta) {
                        meta.addCustomEffect((PotionEffect)o, false);
                    }
                    ((ItemStack)this.potionItem.getSingle(e)).setItemMeta((ItemMeta)meta);
                    break;
                }
                case SET: {
                    meta.clearCustomEffects();
                    meta.setBasePotionData(PotionUtils.getInstance().emptyPotionData());
                    for (Object o : delta) {
                        meta.addCustomEffect((PotionEffect)o, false);
                    }
                    ((ItemStack)this.potionItem.getSingle(e)).setItemMeta((ItemMeta)meta);
                    break;
                }
                case REMOVE: 
                case REMOVE_ALL: {
                    for (Object o : delta) {
                        meta.removeCustomEffect(((PotionEffect)o).getType());
                        if (PotionUtils.getInstance().fromPotionData(meta.getBasePotionData()).getType() != ((PotionEffect)o).getType()) continue;
                        meta.setBasePotionData(PotionUtils.getInstance().emptyPotionData());
                    }
                    ((ItemStack)this.potionItem.getSingle(e)).setItemMeta((ItemMeta)meta);
                    break;
                }
                case DELETE: 
                case RESET: {
                    meta.clearCustomEffects();
                    meta.setBasePotionData(PotionUtils.getInstance().emptyPotionData());
                    ((ItemStack)this.potionItem.getSingle(e)).setItemMeta((ItemMeta)meta);
                }
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE && mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffect[].class});
        }
        return (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffectType[].class});
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends PotionEffect> getReturnType() {
        return PotionEffect.class;
    }

    public String toString(Event e, boolean b) {
        return ((Object)((Object)this)).getClass().getName();
    }
}

