/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.PotionEffectUtils;
import ch.njol.skript.util.Timespan;
import com.sun.istack.internal.Nullable;
import fr.syst3ms.quarsk.classes.EnumType;
import fr.syst3ms.quarsk.conditions.CondHasPotionEffect;
import fr.syst3ms.quarsk.conditions.CondIsWallBanner;
import fr.syst3ms.quarsk.effects.EffLinkReference;
import fr.syst3ms.quarsk.effects.EffOrientTowards;
import fr.syst3ms.quarsk.effects.EffUnlinkReference;
import fr.syst3ms.quarsk.effects.banner.EffApplyBannerItemToBlock;
import fr.syst3ms.quarsk.effects.potion.EffApplyPotionEffects;
import fr.syst3ms.quarsk.effects.potion.EffMilkEntity;
import fr.syst3ms.quarsk.expressions.SExprReference;
import fr.syst3ms.quarsk.expressions.banner.ExprBannerItemFromMnc;
import fr.syst3ms.quarsk.expressions.banner.ExprBannerItemToMnc;
import fr.syst3ms.quarsk.expressions.banner.ExprBannerOrShieldWithLayers;
import fr.syst3ms.quarsk.expressions.banner.ExprCustomBannerLayer;
import fr.syst3ms.quarsk.expressions.banner.ExprRandomBanner;
import fr.syst3ms.quarsk.expressions.banner.SExprBannerBlockBaseColor;
import fr.syst3ms.quarsk.expressions.banner.SExprBannerBlockLayers;
import fr.syst3ms.quarsk.expressions.banner.SExprItemBaseColor;
import fr.syst3ms.quarsk.expressions.banner.SExprItemLayers;
import fr.syst3ms.quarsk.expressions.beacon.ExprBeaconTier;
import fr.syst3ms.quarsk.expressions.beacon.ExprEntitiesInRange;
import fr.syst3ms.quarsk.expressions.beacon.SExprBeaconEffects;
import fr.syst3ms.quarsk.expressions.beacon.SExprBeaconFuel;
import fr.syst3ms.quarsk.expressions.potion.ExprCustomPotionEffect;
import fr.syst3ms.quarsk.expressions.potion.ExprCustomPotionItem;
import fr.syst3ms.quarsk.expressions.potion.ExprEntityPotionEffects;
import fr.syst3ms.quarsk.expressions.potion.ExprPotionEffectDuration;
import fr.syst3ms.quarsk.expressions.potion.ExprPotionEffectTier;
import fr.syst3ms.quarsk.expressions.potion.ExprPotionEffectType;
import fr.syst3ms.quarsk.expressions.potion.SExprItemEffectTypeAmplifier;
import fr.syst3ms.quarsk.expressions.potion.SExprItemEffectTypeDuration;
import fr.syst3ms.quarsk.expressions.potion.SExprPotionItemEffects;
import fr.syst3ms.quarsk.expressions.potion.SExprThrownPotionEffects;
import java.util.ArrayList;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class QuarSk
extends JavaPlugin {
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static QuarSk instance;
    private int events;
    private int conditions;
    private int effects;
    private int expressions;

    public void onEnable() {
        if (this.getServer().getBukkitVersion().startsWith("1.7")) {
            this.getLogger().log(Level.INFO, "");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        instance = this;
        this.normalRegister();
        this.getLogger().log(Level.INFO, "Registered " + this.events + " events, " + this.conditions + " conditions, " + this.effects + " effects and " + this.expressions + " expressions ! Good game !");
    }

    private void normalRegister() {
        Skript.registerAddon((JavaPlugin)this);
        Classes.registerClass((ClassInfo)new ClassInfo(PotionEffect.class, "potioneffect").name("potion effect").description(new String[]{"A getter for potion effects"}).parser((Parser)new Parser<PotionEffect>(){

            @Nullable
            public PotionEffect parse(String obj, ParseContext context) {
                return null;
            }

            public String toString(PotionEffect potionEffect, int i) {
                return PotionEffectUtils.toString((PotionEffectType)potionEffect.getType()) + " of tier " + potionEffect.getAmplifier() + " lasting " + potionEffect.getDuration() + " with particles " + (potionEffect.hasParticles() ? "enabled" : "disabled") + ", ambient effect " + (potionEffect.isAmbient() ? "enabled" : "disabled");
            }

            public String toVariableNameString(PotionEffect potionEffect) {
                return potionEffect.getType() + "," + potionEffect.getAmplifier() + "," + potionEffect.getDuration() + "," + potionEffect.hasParticles() + "," + potionEffect.isAmbient() + "," + potionEffect.getColor();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(Pattern.class, "bannerlayer").name("banner layer").description(new String[]{"A getter for banner layers"}).parser((Parser)new Parser<Pattern>(){

            public Pattern parse(String s, ParseContext parseContext) {
                return null;
            }

            public String toString(Pattern pattern, int i) {
                return "layer with pattern " + EnumType.toString(pattern.getPattern()) + " and color " + pattern.getColor().toString().toLowerCase();
            }

            public String toVariableNameString(Pattern pattern) {
                return "bannerlayer," + pattern.getPattern().toString().toLowerCase() + "," + pattern.getColor().toString().toLowerCase();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        new EnumType(PatternType.class, "bannerpattern", "banner ?pattern(?: ?type)?");
        this.newEffect(EffOrientTowards.class, "orient %livingentity% (0\u00a6towards|1\u00a6away from) %location%", "make %livingentity% (face|look [at]) (0\u00a6[towards]|1\u00a6away from) %location%", "force %livingentity% to (face|look [at]) (0\u00a6[towards]|1\u00a6away from) %location%");
        this.newEffect(EffLinkReference.class, "link @<\\S+> to %object%");
        this.newEffect(EffUnlinkReference.class, "unlink @<\\S+>");
        this.newEffect(EffApplyPotionEffects.class, "apply [potion] [effect[s] [of]] %potioneffects% to %livingentities%");
        this.newEffect(EffMilkEntity.class, "milk %livingentities%");
        this.newEffect(EffApplyBannerItemToBlock.class, "apply (banner|shield) [item] pattern[s] of %itemstack% to [banner] [block] %block%", "apply [item] %itemstack%['s] (banner|shield) pattern[s] to [banner] [block] %block%");
        this.newCondition(CondHasPotionEffect.class, "[entity] %livingentity% (0\u00a6has [got]|1\u00a6has( not|n't) [got]) [(the|a)] %potioneffecttype% [potion] effect");
        this.newCondition(CondIsWallBanner.class, "[banner] [block] %block% (0\u00a6is|1\u00a6is(n't| not)) [a] wall banner");
        this.newExpression(SExprReference.class, Object.class, ExpressionType.SIMPLE, "@<\\S+>");
        this.newExpression(ExprCustomPotionEffect.class, PotionEffect.class, ExpressionType.COMBINED, "[[potion] effect [(with|by)]] %potioneffecttype% for %timespan% with [a] [tier [of]] %number% [particles %-boolean%[ with ambient [effect] %-boolean%[ and [particle] colo[u]r[ed] %-color%]]]]]");
        this.newExpression(ExprCustomPotionItem.class, ItemStack.class, ExpressionType.COMBINED, "(0\u00a6[normal] potion|1\u00a6splash potion|2\u00a6linger[ing] potion|3\u00a6(potion|tipped) arrow) (of|by|with|from|using) [effect[s]] %potioneffects%");
        this.newExpression(ExprEntityPotionEffects.class, PotionEffect.class, ExpressionType.COMBINED, "[(all|every|each)] [active] [potion] effects (on|in) %livingentities%", "[(every|all|each) of] %livingentities%['s] [active] [potion] effect[s]");
        this.newExpression(SExprPotionItemEffects.class, PotionEffect.class, ExpressionType.COMBINED, "[(all|every|each)] [potion] effect[s] (on|of) %itemstack%", "[(all|every|each) of] %itemstack%['s] [potion] effect[s]");
        this.newExpression(ExprPotionEffectType.class, PotionEffectType.class, ExpressionType.COMBINED, "potion[ ]effect[[ ]type][s] of %potioneffect%", "%potioneffect%['s] potion[ ]effect[[ ]type][s]");
        this.newExpression(ExprPotionEffectDuration.class, Timespan.class, ExpressionType.COMBINED, "(duration|length) of [potion] effect[s] %potioneffect%", "[potion] effect[s] %potioneffect%['s] (duration|length)");
        this.newExpression(ExprPotionEffectTier.class, Number.class, ExpressionType.COMBINED, "(tier|amplifier) of [potion] [effect] %potioneffect%", "[potion] [effect] %potioneffect%['s] (tier|amplifier)");
        this.newExpression(SExprItemEffectTypeAmplifier.class, Number.class, ExpressionType.COMBINED, "(tier|amplifier) of [[potion] effect [type]] %potioneffecttype% on [item] %itemstack%", "[[potion] effect [type]] %potioneffecttype%['s] (tier|amplifier) on [item] %itemstack%");
        this.newExpression(SExprItemEffectTypeDuration.class, Timespan.class, ExpressionType.COMBINED, "(duration|length) of [[potion] effect [type]] %potioneffecttype% on [item] %itemstack%", "[[potion] effect [type]] %potioneffecttype%['s] (duration|length) on [item] %itemstack%");
        this.newExpression(SExprThrownPotionEffects.class, PotionEffect.class, ExpressionType.COMBINED, "[all] [potion] effects (of|on) (entity|thrown potion|tipped arrow) %entity%");
        this.newExpression(ExprEntitiesInRange.class, LivingEntity.class, ExpressionType.COMBINED, "[(all|every|each)] ([living] entit(ies|y)|player[s]) in range of %block%");
        this.newExpression(ExprBeaconTier.class, Number.class, ExpressionType.COMBINED, "beacon (tier|level) of %block%", "%block%['s] beacon (tier|level)");
        this.newExpression(SExprBeaconEffects.class, PotionEffect.class, ExpressionType.COMBINED, "[the] (0\u00a6(first|primary)|1\u00a6second[ary]) [potion] effect of [beacon] %block%", "[beacon] %block%['s] (0\u00a6(first|primary)|1\u00a6second[ary]) [potion] effect");
        this.newExpression(SExprBeaconFuel.class, ItemStack.class, ExpressionType.COMBINED, "[the] beacon fuel[ing item[[ ]stack]] of [beacon] %block%", " %block%['s] beacon fuel[ing item[[ ]stack]]");
        this.newExpression(ExprCustomBannerLayer.class, Pattern.class, ExpressionType.COMBINED, "[new] [banner] (layer|pattern) (with|using|of|from) pattern [type] %bannerpattern% colo[u]r[ed] %color%");
        this.newExpression(ExprBannerOrShieldWithLayers.class, ItemStack.class, ExpressionType.COMBINED, "[new] (0\u00a6banner|1\u00a6shield) (from|with|using|of) [[banner] (layer|pattern)[s]] %bannerlayers%");
        this.newExpression(SExprBannerBlockLayers.class, Pattern.class, ExpressionType.COMBINED, "[(all|each|every)] [banner] (layer|pattern)[s] of [(block|banner)] %block%", "[(all|every|each) of] %block%['s] [banner] (layer|pattern)[s]");
        this.newExpression(SExprItemLayers.class, Pattern.class, ExpressionType.COMBINED, "[(all|each|every)] [banner] (layer|pattern)[s] of [(shield|banner|item)] %itemstack%", "[(all|every|each) of] %itemstack%['s] [banner] (layer|pattern)[s]");
        this.newExpression(SExprItemBaseColor.class, Color.class, ExpressionType.COMBINED, "[(banner|shield)] bas(e|ic) color of item %itemstack%", "item %itemstack%['s] [(banner|shield)] bas(e|ic) color");
        this.newExpression(SExprBannerBlockBaseColor.class, Color.class, ExpressionType.COMBINED, "[banner] block bas(e|ic) color of block %block%", "block %block%['s] [banner] bas(e|ic) color");
        this.newExpression(ExprBannerItemFromMnc.class, ItemStack.class, ExpressionType.COMBINED, "(0\u00a6banner|1\u00a6shield) [item] from [m[iners]]n[eed]c[ool][s[hoes]] [code] %string%");
        this.newExpression(ExprBannerItemToMnc.class, String.class, ExpressionType.COMBINED, "[m[iners]]n[eed]c[ool][s[hoes]] code of [(banner|shield|item)] %itemstack%", "[(banner|shield|item)] %itemstack%['s] [m[iners]]n[eed]c[ool][s[hoes]] code");
        this.newExpression(ExprRandomBanner.class, ItemStack.class, ExpressionType.SIMPLE, "[a] [new] random (0\u00a6banner|1\u00a6shield)");
    }

    public void onDisable() {
    }

    public <E extends Expression<T>, T> void newExpression(Class<E> clazz, Class<T> returnType, ExpressionType type, String ... syntaxes) {
        Skript.registerExpression(clazz, returnType, (ExpressionType)type, (String[])this.prefixEachString(this.getSyntaxPrefix(), syntaxes));
        ++this.expressions;
    }

    public <E extends Effect> void newEffect(Class<E> clazz, String ... syntaxes) {
        Skript.registerEffect(clazz, (String[])this.prefixEachString(this.getSyntaxPrefix(), syntaxes));
        ++this.effects;
    }

    public <C extends Condition> void newCondition(Class<C> clazz, String ... syntaxes) {
        Skript.registerCondition(clazz, (String[])this.prefixEachString(this.getSyntaxPrefix(), syntaxes));
        ++this.conditions;
    }

    public <E extends SkriptEvent> void newEvent(Class<E> c, Class<? extends Event> eventClass, String name, String ... syntaxes) {
        Skript.registerEvent((String)name, c, eventClass, (String[])this.prefixEachString(this.getSyntaxPrefix(), syntaxes));
        ++this.events;
    }

    public String getPrefix() {
        return "[QuarSk] ";
    }

    public String getSyntaxPrefix() {
        return "[quar[s]k] ";
    }

    public String[] prefixEachString(String prefix, String ... strings) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (String str : strings) {
            stringList.add(prefix + str);
        }
        return stringList.toArray(new String[strings.length]);
    }

    public String[] suffixEachString(String suffix, String ... strings) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (String str : strings) {
            stringList.add(str + suffix);
        }
        return stringList.toArray(new String[strings.length]);
    }

    public static QuarSk getInstance() {
        return instance;
    }

    public String getVersion() {
        return "1.2";
    }

    public Vector vectorFromLocations(Location from, Location to) {
        return new Vector(to.getX() - from.getX(), to.getY() - from.getY(), to.getZ() - from.getZ());
    }

    public float getYaw(Vector vector) {
        if (Double.valueOf(vector.getX()).equals(0.0) && Double.valueOf(vector.getZ()).equals(0.0)) {
            return 0.0f;
        }
        return (float)(Math.atan2(vector.getZ(), vector.getX()) * 57.29577951308232);
    }

    public float getPitch(Vector vector) {
        double xy = Math.sqrt(vector.getX() * vector.getX() + vector.getZ() * vector.getZ());
        return (float)(Math.atan(vector.getY() / xy) * 57.29577951308232);
    }

    public float notchYaw(float yaw) {
        float y = yaw - 90.0f;
        if (y < -180.0f) {
            y += 360.0f;
        }
        return y;
    }

    public float notchPitch(float pitch) {
        return -pitch;
    }

    public void debug(Object ... l) {
        for (Object o : l) {
            Bukkit.getLogger().log(Level.INFO, this.getPrefix() + " " + o.toString());
        }
    }
}

