/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.potion;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import fr.syst3ms.quarsk.QuarSk;
import fr.syst3ms.quarsk.util.PotionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class SExprItemEffectTypeDuration
extends SimpleExpression<Timespan> {
    private Expression<PotionEffectType> effectType;
    private Expression<ItemStack> item;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.effectType = expr[0];
        this.item = expr[1];
        return true;
    }

    protected Timespan[] get(Event e) {
        if (this.effectType != null && this.item != null && this.effectType.getSingle(e) != null && this.item.getSingle(e) != null && PotionUtils.isPotionItem((ItemStack)this.item.getSingle(e))) {
            PotionMeta meta = (PotionMeta)((ItemStack)this.item.getSingle(e)).getItemMeta();
            return new Timespan[]{Timespan.fromTicks_i((long)PotionUtils.getEffectByEffectType(meta, (PotionEffectType)this.effectType.getSingle(e)).getDuration())};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.effectType != null && this.item != null && this.effectType.getSingle(e) != null && this.item.getSingle(e) != null && PotionUtils.isPotionItem((ItemStack)this.item.getSingle(e))) {
            PotionEffect potionEffect;
            PotionMeta meta = (PotionMeta)((ItemStack)this.item.getSingle(e)).getItemMeta();
            PotionEffect potionEffect2 = potionEffect = meta.getBasePotionData().getType() != PotionType.UNCRAFTABLE ? PotionUtils.getEffectByEffectType(meta, (PotionEffectType)this.effectType.getSingle(e)) : PotionUtils.fromPotionData(meta.getBasePotionData());
            if (meta.getBasePotionData().getType() != PotionType.UNCRAFTABLE) {
                meta.removeCustomEffect((PotionEffectType)this.effectType.getSingle(e));
            } else {
                meta.setBasePotionData(PotionUtils.emptyPotionData());
            }
            Timespan timespan = (Timespan)delta[0];
            switch (mode) {
                case ADD: {
                    meta.addCustomEffect(new PotionEffect(potionEffect.getType(), potionEffect.getDuration() + Math.toIntExact(timespan.getTicks_i()), potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles(), potionEffect.getColor()), true);
                    break;
                }
                case SET: {
                    meta.addCustomEffect(new PotionEffect(potionEffect.getType(), Math.toIntExact(timespan.getTicks_i()), potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles(), potionEffect.getColor()), true);
                    break;
                }
                case REMOVE: {
                    meta.addCustomEffect(new PotionEffect(potionEffect.getType(), potionEffect.getDuration() - Math.toIntExact(timespan.getTicks_i()) > 0 ? potionEffect.getDuration() - Math.toIntExact(timespan.getTicks_i()) : potionEffect.getDuration(), potionEffect.getAmplifier(), potionEffect.isAmbient(), potionEffect.hasParticles(), potionEffect.getColor()), true);
                }
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL && mode != Changer.ChangeMode.RESET && mode != Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class});
        }
        return null;
    }

    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(Event event, boolean b) {
        return ((Object)((Object)this)).getClass().getName();
    }

    static {
        QuarSk.newExpression(SExprItemEffectTypeDuration.class, Timespan.class, ExpressionType.COMBINED, "(duration|length) of [[potion] effect [type]] %potioneffecttype% on [item] %itemstack%", "[[potion] effect [type]] %potioneffecttype%['s] (duration|length) on [item] %itemstack%");
    }
}

