/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.potion;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import fr.syst3ms.quarsk.QuarSk;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public class ExprCustomPotionItem
extends SimpleExpression<ItemStack> {
    private Material material;
    private Expression<PotionEffect> potionEffects;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        switch (parseResult.mark) {
            case 0: {
                this.material = Material.POTION;
                break;
            }
            case 1: {
                this.material = Material.SPLASH_POTION;
                break;
            }
            case 2: {
                this.material = Material.LINGERING_POTION;
                break;
            }
            case 3: {
                this.material = Material.TIPPED_ARROW;
                break;
            }
            default: {
                this.material = Material.POTION;
            }
        }
        this.potionEffects = expr[0];
        return true;
    }

    protected ItemStack[] get(Event e) {
        ItemStack item = new ItemStack(this.material, 1);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        Stream.of(this.potionEffects.getAll(e)).forEach(eff -> meta.addCustomEffect(eff, true));
        item.setItemMeta((ItemMeta)meta);
        return new ItemStack[]{item};
    }

    public Class getReturnType() {
        return ItemStack.class;
    }

    public String toString(Event event, boolean b) {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isSingle() {
        return true;
    }

    static {
        QuarSk.newExpression(ExprCustomPotionItem.class, ItemStack.class, ExpressionType.COMBINED, "(0\u00a6[normal] potion|1\u00a6splash potion|2\u00a6linger[ing] potion|3\u00a6(potion|tipped) arrow) (of|by|with|from|using) [effect[s]] %potioneffects%");
    }
}

