/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.PotionEffectUtils;
import com.sun.istack.internal.Nullable;
import fr.syst3ms.quarsk.classes.EnumType;
import fr.syst3ms.quarsk.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class QuarSk
extends JavaPlugin {
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static SkriptAddon addonInstance;
    private static HashMap<Class<?>, String[]> events;
    private static HashMap<Class<?>, String[]> conditions;
    private static HashMap<Class<?>, String[]> effects;
    private static HashMap<Class<?>, String[]> expressions;
    private static JavaPlugin plugin;

    public void onEnable() {
        if (this.getServer().getBukkitVersion().startsWith("1.7")) {
            this.getLogger().log(Level.INFO, "");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        plugin = this;
        this.normalRegister();
        if (QuarSk.generateFolder()) {
            this.getLogger().log(Level.INFO, "Created QuarSk's folder !");
        }
        if (QuarSk.generateSyntaxFile()) {
            this.getLogger().log(Level.INFO, "Generated QuarSk's syntax file !");
        }
        this.getLogger().log(Level.INFO, "Registered " + events.size() + " events, " + conditions.size() + " conditions, " + effects.size() + " effects and " + expressions.size() + " expressions ! Good game !");
    }

    private void normalRegister() {
        addonInstance = Skript.registerAddon((JavaPlugin)this);
        Classes.registerClass((ClassInfo)new ClassInfo(PotionEffect.class, "potioneffect").name("potion effect").description(new String[]{"A getter for potion effects"}).parser((Parser)new Parser<PotionEffect>(){

            @Nullable
            public PotionEffect parse(String obj, ParseContext context) {
                return null;
            }

            public String toString(PotionEffect potionEffect, int i) {
                return PotionEffectUtils.toString((PotionEffectType)potionEffect.getType()) + " of tier " + potionEffect.getAmplifier() + " lasting " + potionEffect.getDuration() + " with particles " + (potionEffect.hasParticles() ? "enabled" : "disabled") + ", ambient effect " + (potionEffect.isAmbient() ? "enabled" : "disabled");
            }

            public String toVariableNameString(PotionEffect potionEffect) {
                return potionEffect.getType() + "," + potionEffect.getAmplifier() + "," + potionEffect.getDuration() + "," + potionEffect.hasParticles() + "," + potionEffect.isAmbient() + "," + potionEffect.getColor();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(Pattern.class, "bannerlayer").name("banner layer").description(new String[]{"A getter for banner layers"}).parser((Parser)new Parser<Pattern>(){

            public Pattern parse(String s, ParseContext parseContext) {
                return null;
            }

            public String toString(Pattern pattern, int i) {
                return "layer with pattern " + EnumType.toString(pattern.getPattern()) + " and color " + pattern.getColor().toString().toLowerCase();
            }

            public String toVariableNameString(Pattern pattern) {
                return "bannerlayer," + pattern.getPattern().toString().toLowerCase() + "," + pattern.getColor().toString().toLowerCase();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        EnumType.newType(PatternType.class, "bannerpattern", "banner ?pattern(?: ?type)?");
        try {
            QuarSk.getAddon().loadClasses("fr.syst3ms.quarsk", new String[]{"conditions", "effects", "events", "expressions"});
            QuarSk.getAddon().loadClasses("fr.syst3ms.quarsk.effects", new String[]{"banner", "potion"});
            QuarSk.getAddon().loadClasses("fr.syst3ms.quarsk.expressions", new String[]{"banner", "beacon", "eventvalues", "potion"});
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, (String[])new String[]{"An error has occured while registering QuarSk's syntax", "Report this error to me, Syst3ms, and I will (hopefully) fix it"});
        }
    }

    public void onDisable() {
    }

    public static <E extends Expression<T>, T> void newExpression(Class<E> clazz, Class<T> returnType, ExpressionType type, String ... syntaxes) {
        Skript.registerExpression(clazz, returnType, (ExpressionType)type, (String[])QuarSk.prefixEachString(QuarSk.getSyntaxPrefix(), syntaxes));
        expressions.put(clazz, syntaxes);
    }

    public static <E extends Effect> void newEffect(Class<E> clazz, String ... syntaxes) {
        Skript.registerEffect(clazz, (String[])QuarSk.prefixEachString(QuarSk.getSyntaxPrefix(), syntaxes));
        effects.put(clazz, syntaxes);
    }

    public static <C extends Condition> void newCondition(Class<C> clazz, String ... syntaxes) {
        Skript.registerCondition(clazz, (String[])QuarSk.prefixEachString(QuarSk.getSyntaxPrefix(), syntaxes));
        conditions.put(clazz, syntaxes);
    }

    public static <E extends SkriptEvent> void newEvent(String name, Class<E> skriptEvent, Class<? extends Event> event, String ... syntaxes) {
        Skript.registerEvent((String)name, skriptEvent, event, (String[])syntaxes);
        events.put(skriptEvent, syntaxes);
    }

    private static boolean generateFolder() {
        if (!QuarSk.getPlugin().getDataFolder().exists()) {
            return QuarSk.getPlugin().getDataFolder().mkdirs();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean generateSyntaxFile() {
        BufferedWriter fileWriter;
        File syntaxFile = new File(((QuarSk)QuarSk.getPlugin(QuarSk.class)).getDataFolder(), "syntax.txt");
        String newLine = System.getProperty("line.separator");
        if (!syntaxFile.exists()) {
            try {
                syntaxFile.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
        } else {
            syntaxFile.delete();
        }
        try {
            fileWriter = new BufferedWriter(new FileWriter(syntaxFile));
        }
        catch (IOException e) {
            return false;
        }
        try {
            String syntaxName;
            QuarSk.writeLine(fileWriter, "Events :");
            for (Map.Entry<Class<?>, String[]> entry : events.entrySet()) {
                syntaxName = StringUtils.space("(?<!^)(?=[A-Z])", entry.getKey().getSimpleName().replaceAll("Skript", ""));
                for (String s : entry.getValue()) {
                    QuarSk.writeLine(fileWriter, "  - " + syntaxName + " : " + s);
                }
            }
            QuarSk.writeLine(fileWriter, "Conditions :");
            for (Map.Entry<Class<?>, String[]> entry : conditions.entrySet()) {
                syntaxName = StringUtils.space("(?<!^)(?=[A-Z])", entry.getKey().getSimpleName().replaceAll("^Cond", ""));
                for (String s : entry.getValue()) {
                    QuarSk.writeLine(fileWriter, "  - " + syntaxName + " : " + s);
                }
            }
            QuarSk.writeLine(fileWriter, "Effects :");
            for (Map.Entry<Class<?>, String[]> entry : effects.entrySet()) {
                syntaxName = StringUtils.space("(?<!^)(?=[A-Z])", entry.getKey().getSimpleName().replaceAll("^Eff", ""));
                for (String s : entry.getValue()) {
                    QuarSk.writeLine(fileWriter, "  - " + syntaxName + " : " + s);
                }
            }
            QuarSk.writeLine(fileWriter, "Expressions :");
            for (Map.Entry<Class<?>, String[]> entry : expressions.entrySet()) {
                syntaxName = StringUtils.space("(?<!^)(?=[A-Z])", entry.getKey().getSimpleName().replaceAll("^S?Expr", ""));
                for (String s : entry.getValue()) {
                    QuarSk.writeLine(fileWriter, "  - " + syntaxName + " : " + s);
                }
            }
            boolean e = true;
            return e;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                Skript.exception((Throwable)e, (String[])new String[0]);
            }
        }
    }

    public static String getPrefix() {
        return "[QuarSk] ";
    }

    public static void writeLine(BufferedWriter writer, String s) throws IOException {
        writer.write(s);
        writer.newLine();
    }

    public static SkriptAddon getAddon() {
        return addonInstance;
    }

    public static JavaPlugin getPlugin() {
        return plugin;
    }

    public static String getSyntaxPrefix() {
        return "[quar[s]k] ";
    }

    public static String[] prefixEachString(String prefix, String ... strings) {
        return (String[])Stream.of(strings).map(s -> prefix + s).toArray(String[]::new);
    }

    public static String[] suffixEachString(String suffix, String ... strings) {
        return (String[])Stream.of(strings).map(s -> s + suffix).toArray(String[]::new);
    }

    public static String getVersion() {
        return "1.2";
    }

    public static Vector vectorFromLocations(Location from, Location to) {
        return new Vector(to.getX() - from.getX(), to.getY() - from.getY(), to.getZ() - from.getZ());
    }

    public static float getYaw(Vector vector) {
        if (Double.valueOf(vector.getX()).equals(0.0) && Double.valueOf(vector.getZ()).equals(0.0)) {
            return 0.0f;
        }
        return (float)(Math.atan2(vector.getZ(), vector.getX()) * 57.29577951308232);
    }

    public static float getPitch(Vector vector) {
        double xy = Math.sqrt(vector.getX() * vector.getX() + vector.getZ() * vector.getZ());
        return (float)(Math.atan(vector.getY() / xy) * 57.29577951308232);
    }

    public static float notchYaw(float yaw) {
        float y = yaw - 90.0f;
        if (y < -180.0f) {
            y += 360.0f;
        }
        return y;
    }

    public static float notchPitch(float pitch) {
        return -pitch;
    }

    public static void debug(Object ... l) {
        Arrays.asList(l).forEach(s -> Bukkit.getLogger().log(Level.INFO, s.toString()));
    }

    static {
        events = new HashMap();
        conditions = new HashMap();
        effects = new HashMap();
        expressions = new HashMap();
    }
}

