/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Timespan;
import com.google.common.collect.Iterators;
import com.sun.istack.internal.Nullable;
import fr.syst3ms.quarsk.conditions.CondHasPotionEffect;
import fr.syst3ms.quarsk.effects.EffLinkReference;
import fr.syst3ms.quarsk.effects.EffOrientTowards;
import fr.syst3ms.quarsk.effects.EffUnlinkReference;
import fr.syst3ms.quarsk.effects.potion.EffApplyPotionEffects;
import fr.syst3ms.quarsk.effects.potion.EffMilkEntity;
import fr.syst3ms.quarsk.expressions.SExprReference;
import fr.syst3ms.quarsk.expressions.potion.ExprCustomPotionEffect;
import fr.syst3ms.quarsk.expressions.potion.ExprCustomPotionItem;
import fr.syst3ms.quarsk.expressions.potion.ExprEntityPotionEffects;
import fr.syst3ms.quarsk.expressions.potion.ExprPotionEffectDuration;
import fr.syst3ms.quarsk.expressions.potion.ExprPotionEffectTier;
import fr.syst3ms.quarsk.expressions.potion.ExprPotionEffectType;
import fr.syst3ms.quarsk.expressions.potion.ExprPotionItemEffects;
import java.util.Iterator;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Vector;

public class QuarSk
extends JavaPlugin {
    public static final double RAD_TO_DEG = 57.29577951308232;
    private static QuarSk instance;

    public void onEnable() {
        instance = this;
        this.getLogger().log(Level.INFO, "There are " + Skript.getEvents().size() + " events, " + Skript.getConditions().size() + " conditions, " + Skript.getEffects().size() + " effects and " + Iterators.size((Iterator)Skript.getExpressions()) + " expressions registered !");
        this.getLogger().log(Level.INFO, "Enabling QuarSk " + QuarSk.getVersion() + " to give these numbers a boost !");
        this.normalRegister();
        this.getLogger().log(Level.INFO, "Now, there are " + Skript.getEvents().size() + " events, " + Skript.getConditions().size() + " conditions and " + Skript.getEffects().size() + " effects and " + Iterators.size((Iterator)Skript.getExpressions()) + " expressions registered ! Good game !");
    }

    public void onDisable() {
        this.getLogger().info("Disabling QuarSk 1.0 ! Goodbye !");
    }

    private void normalRegister() {
        Skript.registerAddon((JavaPlugin)this);
        Classes.registerClass((ClassInfo)new ClassInfo(PotionEffect.class, "potioneffect").name("potion effect").description(new String[]{"A getter for potion effects"}).parser((Parser)new Parser<PotionEffect>(){

            @Nullable
            public PotionEffect parse(String obj, ParseContext context) {
                return null;
            }

            public String toString(PotionEffect potionEffect, int i) {
                return "effect" + potionEffect.getType() + ", tier " + potionEffect.getAmplifier() + ", duration " + potionEffect.getDuration() + ", particles " + potionEffect.hasParticles() + ", ambient " + potionEffect.isAmbient() + ", color " + potionEffect.getColor();
            }

            public String toVariableNameString(PotionEffect potionEffect) {
                return potionEffect.getType() + "," + potionEffect.getAmplifier() + "," + potionEffect.getDuration() + "," + potionEffect.hasParticles() + "," + potionEffect.isAmbient() + "," + potionEffect.getColor();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        Skript.registerEffect(EffOrientTowards.class, (String[])new String[]{"(orient %entity%|(make %entity%|force %entity% to) (face|look)) (0\u00a6towards|1\u00a6away from) %location%"});
        Skript.registerEffect(EffLinkReference.class, (String[])new String[]{"link @<\\S+> to %object%"});
        Skript.registerEffect(EffUnlinkReference.class, (String[])new String[]{"unlink @<\\S+>"});
        Skript.registerEffect(EffApplyPotionEffects.class, (String[])new String[]{"apply [potion] [effect[s] [of]] %potioneffects% to %livingentities%"});
        Skript.registerEffect(EffMilkEntity.class, (String[])new String[]{"milk %livingentities%"});
        Skript.registerCondition(CondHasPotionEffect.class, (String[])new String[]{"[entity] %livingentity% (0\u00a6has [got]|1\u00a6has( not|n't) [got]) [(the|a)] %potioneffecttype% [potion] effect"});
        Skript.registerExpression(SExprReference.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"@<\\S+>"});
        Skript.registerExpression(ExprCustomPotionEffect.class, PotionEffect.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[[potion] effect [(with|by)]] %potioneffecttype% for %timespan% with [a] [tier [of]] %number% [particles %-boolean%[ with ambient [effect] %-boolean%[ and [particle] colo[u]r[ed] %-color%]]]]]"});
        Skript.registerExpression(ExprCustomPotionItem.class, ItemStack.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(0\u00a6normal|1\u00a6splash|2\u00a6linger[ing])] potion (of|by|with|from) [effect[s]] %potioneffects%"});
        Skript.registerExpression(ExprEntityPotionEffects.class, PotionEffect.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all|every|each)] [active] [potion] effects (on|in) %livingentities%", "[(every|all|each) of] %livingentities%['s] [active] [potion] effect[s]"});
        Skript.registerExpression(ExprPotionItemEffects.class, PotionEffect.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all|every|each)] [potion] effect[s] (on|of) %itemstack%", "[(all|every|each) of] %itemstack%['s] [potion] effect[s]"});
        Skript.registerExpression(ExprPotionEffectType.class, PotionEffectType.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"potion[ ]effect[[ ]type][s] of %potioneffect%", "%potioneffect%['s] potion[ ]effect[[ ]type][s]"});
        Skript.registerExpression(ExprPotionEffectDuration.class, Timespan.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(duration|length) of [potion] effect[s] %potioneffect%", "[potion] effect[s] %potioneffect%['s] (duration|length)"});
        Skript.registerExpression(ExprPotionEffectTier.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(tier|level|amplifier|power) of [potion] [effect] %potioneffect%", "[potion] [effect] %potioneffect%['s] (tier|amplifier|level|power)"});
    }

    public static PotionEffect fromPotionData(PotionData data) {
        PotionEffectType type = data.getType().getEffectType();
        if (type == PotionEffectType.HEAL || type == PotionEffectType.HARM) {
            if (data.isUpgraded()) {
                return new PotionEffect(type, 1, 2);
            }
            return new PotionEffect(type, 1, 1);
        }
        if (type == PotionEffectType.REGENERATION || type == PotionEffectType.POISON) {
            if (data.isExtended()) {
                return new PotionEffect(type, 1800, 1);
            }
            if (data.isUpgraded()) {
                return new PotionEffect(type, 440, 2);
            }
            return new PotionEffect(type, 900, 1);
        }
        if (type == PotionEffectType.NIGHT_VISION || type == PotionEffectType.INVISIBILITY || type == PotionEffectType.FIRE_RESISTANCE || type == PotionEffectType.WATER_BREATHING) {
            if (data.isExtended()) {
                return new PotionEffect(type, 9600, 1);
            }
            return new PotionEffect(type, 3600, 1);
        }
        if (type == PotionEffectType.WEAKNESS || type == PotionEffectType.SLOW) {
            if (data.isExtended()) {
                return new PotionEffect(type, 4800, 1);
            }
            return new PotionEffect(type, 1800, 1);
        }
        if (data.isExtended()) {
            return new PotionEffect(type, 9600, 1);
        }
        if (data.isUpgraded()) {
            return new PotionEffect(type, 1800, 2);
        }
        return new PotionEffect(type, 3600, 1);
    }

    public static PotionData emptyPotionData() {
        return new PotionData(PotionType.WATER);
    }

    public static String getPrefix() {
        return "[QuarSk] ";
    }

    public static QuarSk getInstance() {
        return instance;
    }

    public static String getVersion() {
        return "1.1";
    }

    public static Vector vectorFromLocations(Location from, Location to) {
        return new Vector(to.getX() - from.getX(), to.getY() - from.getY(), to.getZ() - from.getZ());
    }

    public static float getYaw(Vector vector) {
        if (Double.valueOf(vector.getX()).equals(0.0) && Double.valueOf(vector.getZ()).equals(0.0)) {
            return 0.0f;
        }
        return (float)(Math.atan2(vector.getZ(), vector.getX()) * 57.29577951308232);
    }

    public static float getPitch(Vector vector) {
        double xy = Math.sqrt(vector.getX() * vector.getX() + vector.getZ() * vector.getZ());
        return (float)(Math.atan(vector.getY() / xy) * 57.29577951308232);
    }

    public static float notchYaw(float yaw) {
        float y = yaw - 90.0f;
        if (y < -180.0f) {
            y += 360.0f;
        }
        return y;
    }

    public static float notchPitch(float pitch) {
        return -pitch;
    }

    public static void debug(Object ... l) {
        for (Object o : l) {
            Bukkit.getLogger().log(Level.INFO, QuarSk.getPrefix() + " " + o.toString());
        }
    }
}

