/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.quarsk.expressions.potion;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public class ExprCustomPotionItem
extends SimpleExpression {
    private Material material;
    private Expression<PotionEffect> potionEffects;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        switch (parseResult.mark) {
            case 0: {
                this.material = Material.POTION;
                break;
            }
            case 1: {
                this.material = Material.SPLASH_POTION;
                break;
            }
            case 2: {
                this.material = Material.LINGERING_POTION;
                break;
            }
            case 3: {
                this.material = Material.TIPPED_ARROW;
                break;
            }
            default: {
                this.material = Material.POTION;
            }
        }
        this.potionEffects = expr[0];
        return true;
    }

    protected Object[] get(Event e) {
        PotionEffect[] effect;
        ItemStack item = new ItemStack(this.material, 1);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        for (PotionEffect eff : effect = (PotionEffect[])this.potionEffects.getAll(e)) {
            meta.addCustomEffect(eff, true);
        }
        item.setItemMeta((ItemMeta)meta);
        return new ItemStack[]{item};
    }

    public Class getReturnType() {
        return ItemStack.class;
    }

    public String toString(Event event, boolean b) {
        return null;
    }

    public boolean isSingle() {
        return true;
    }
}

