package me.pugabear.PurpleSk.Expressions;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

import com.cnaude.purpleirc.PurpleIRC;
import com.cnaude.purpleirc.ext.org.pircbotx.Channel;
import com.cnaude.purpleirc.ext.org.pircbotx.User;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;

public class ExprUserHostmask extends SimpleExpression<String> {
	
	public static String syntax = "[irc] (user hostmask|hostmask of [user]) %string% in [channel] %string% with bot %string%";

	private Expression<String> bot;
	private Expression<String> channel;
	private Expression<String> user;
	
	@Override
	public Class<? extends String> getReturnType() {
		return String.class;
	}

	@Override
	public boolean isSingle() {
		return true;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] e, int arg1, Kleenean arg2, ParseResult arg3) {
		user = (Expression<String>) e[0];
		channel = (Expression<String>) e[1];
		bot = (Expression<String>) e[2];
		return true;
	}

	@Override
	public String toString(Event arg0, boolean arg1) {
		return syntax;
	}

	@Override
	protected String[] get(Event e) {
		Plugin plugin = Bukkit.getPluginManager().getPlugin("PurpleIRC"); 
		PurpleIRC pirc = (PurpleIRC) plugin;
		String b = bot.getSingle(e);
		String c = channel.getSingle(e);
		String u = user.getSingle(e);
		if (!c.contains("#")) {
			c = "#" + c;
		}
		if (pirc.ircBots.containsKey(b) && b != null && c != null && u != null) {
            Channel channel = pirc.ircBots.get(b).getChannel(c);
            if (channel != null) {
                for (User user : channel.getUsers()) {
                    if (user.getNick().equalsIgnoreCase(u)) {
                    	return new String[] { "*!*" + user.getLogin() + "@" + user.getHostmask() };
                    }
                }
            } else {
				Skript.error("Channel \"" + c + "\" is null");
            }
		} else {
			Skript.error("Bot \"" + b + "\" not found or arguments null");
		}
		return new String[] { null };
	}

	public static void register() {
		Skript.registerExpression(ExprUserHostmask.class, String.class, ExpressionType.SIMPLE, syntax);
	}

}
