package me.pugabear.PurpleSk.Expressions;

import java.util.ArrayList;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

import com.cnaude.purpleirc.PurpleIRC;
import com.cnaude.purpleirc.ext.org.pircbotx.Channel;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;

public class ExprOpsList extends SimpleExpression<String> {

	public static String syntax = "[irc] list (ops|opped [users]) in [channel] %string% with bot %string%";

	private Expression<String> bot;
	private Expression<String> channel;
	
	@Override
	public Class<? extends String> getReturnType() {
		return String.class;
	}

	@Override
	public boolean isSingle() {
		return true;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] e, int arg1, Kleenean arg2, ParseResult arg3) {
		channel = (Expression<String>) e[0];
		bot = (Expression<String>) e[1];
		return true;
	}

	@Override
	public String toString(Event arg0, boolean arg1) {
		return syntax;
	}

	@Override
	protected String[] get(Event e) {
		Plugin plugin = Bukkit.getPluginManager().getPlugin("PurpleIRC"); 
		PurpleIRC pirc = (PurpleIRC) plugin;
		String b = bot.getSingle(e);
		String c = channel.getSingle(e);
		if (!c.contains("#")) {
			c = "#" + c;
		}
		ArrayList<String> users = new ArrayList<>();
		if (pirc.ircBots.containsKey(b) && b != null && c != null) {
			Channel chan = pirc.ircBots.get(b).getChannel(c);
			if (chan != null) {
				if (pirc.ircBots.get(b).opsList.containsKey(c)) {
                    for (String mask : pirc.ircBots.get(b).opsList.get(c)) {
                        users.add(mask);
                    }
				} else {
					Skript.error("Channel \"" + c + "\" is invalid");
				} 
			} else {
				Skript.error("Channel \"" + c + "\" is null");
			}
		} else {
			Skript.error("Bot \"" + b + "\" not found or arguments null");
			return null;
		}
		String[] list = users.toArray(new String[users.size()]);
		return list;
	}

	public static void register() {
		Skript.registerExpression(ExprOpsList.class, String.class, ExpressionType.SIMPLE, syntax);
	}

}
