package me.pugabear.PurpleSk.Expressions;

import java.util.ArrayList;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

import com.cnaude.purpleirc.PurpleIRC;
import com.cnaude.purpleirc.ext.org.pircbotx.Channel;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;

public class ExprChannels extends SimpleExpression<String> {
	
	public static String syntax = "[irc] channels of bot %string%";

	private Expression<String> bot;
	
	@Override
	public Class<? extends String> getReturnType() {
		return String.class;
	}

	@Override
	public boolean isSingle() {
		return true;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] e, int arg1, Kleenean arg2, ParseResult arg3) {
		bot = (Expression<String>) e[0];
		return true;
	}

	@Override
	public String toString(Event arg0, boolean arg1) {
		return syntax;
	}

	@Override
	protected String[] get(Event e) {
		Plugin plugin = Bukkit.getPluginManager().getPlugin("PurpleIRC"); 
		PurpleIRC pirc = (PurpleIRC) plugin;
		String b = bot.getSingle(e);
		ArrayList<String> chans = new ArrayList<>();
		if (pirc.ircBots.containsKey(b) && b != null) {
			for (Channel channel : pirc.ircBots.get(b).getChannels()) {
				chans.add(channel.getName());
			}
		} else {
			Skript.error("Bot \"" + b + "\" not found or arguments null");
			return null;
		}
		String[] list = chans.toArray(new String[chans.size()]);
		return list;
	}

	public static void register() {
		Skript.registerExpression(ExprChannels.class, String.class, ExpressionType.SIMPLE, syntax);
	}

}
