package me.pugabear.PurpleSk.Effects;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

import com.cnaude.purpleirc.PurpleIRC;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

public class EffSay extends Effect {
	
	public static String syntax = "[irc] (say|send) %string% (in|to) [channel] %string% with bot %string%";
	
	private Expression<String> bot;
	private Expression<String> channel;
	private Expression<String> message;
	
	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] e, int arg1, Kleenean arg2, ParseResult arg3) {
		message = (Expression<String>) e[0];
		channel = (Expression<String>) e[1];
		bot = (Expression<String>) e[2];
		return true;
	}
	
	@Override
	public String toString(Event paramEvent, boolean paramBoolean) {
		return syntax;
	}
	
	@Override
	protected void execute(Event e) {
		Plugin plugin = Bukkit.getPluginManager().getPlugin("PurpleIRC"); 
		PurpleIRC pirc = (PurpleIRC) plugin;
		String b = bot.getSingle(e);
		String c = channel.getSingle(e);
		String m = message.getSingle(e);
		if (!c.contains("#")) {
			c = "#" + c;
		}
		if (pirc.ircBots.containsKey(b) && b != null && c != null && m != null) {
			pirc.ircBots.get(b).asyncIRCMessage(c, m);
		} else {
			Skript.error("Bot \"" + b + "\" not found or arguments null");
		}
	}
	

	public static void register() {
		Skript.registerEffect(EffSay.class, syntax);
	}
}