package me.pugabear.PurpleSk.EventExpressions;

import org.bukkit.event.Event;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import me.pugabear.PurpleSk.Events.MessageEvent;

public class SExprMessage extends SimpleExpression<String> {
	
	public static String syntax = "irc [event(-| )]message";

	@Override
	public Class<? extends String> getReturnType() {
		return String.class;
	}

	@Override
	public boolean isSingle() {
		return true;
	}

	@Override
	public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, ParseResult arg3) {
		if (!ScriptLoader.isCurrentEvent(MessageEvent.class)) {
			Skript.error("You must use the irc message expression inside the irc message event.");
			return false;
		} else {
			return true;
		}
	}

	@Override
	public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
		if (mode == Changer.ChangeMode.SET) {
			if (e instanceof MessageEvent){
				MessageEvent me = (MessageEvent) e;
				me.getOriginalEvent().setMessage((String) delta[0]);
			}
		}
	}
	
	@Override
	public Class<?>[] acceptChange(final Changer.ChangeMode mode) {
		if (mode == Changer.ChangeMode.SET) {
			return CollectionUtils.array(String.class);
		}
		return null;
	}
	
	@Override
	public String toString(Event arg0, boolean arg1) {
		return syntax;
	}

	@Override
	protected String[] get(Event e) {
		MessageEvent event = ((MessageEvent) e);
		return new String[] { event.getMessage() };
	}

	static {
		Skript.registerExpression(SExprMessage.class, String.class, ExpressionType.SIMPLE, syntax);
	}

}
