package me.pugabear.PurpleSk.Effects;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

import com.cnaude.purpleirc.PurpleIRC;
import com.cnaude.purpleirc.ext.org.pircbotx.Channel;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

public class EffLeave extends Effect {
	
	public static String syntax = "[irc] leave [channel] %string% [[with] reason %-string%] with bot %string%";
	
	private Expression<String> bot;
	private Expression<String> channel;
	private Expression<String> reason = null;
	
	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] e, int arg1, Kleenean arg2, ParseResult arg3) {
		channel = (Expression<String>) e[0];
		reason = (Expression<String>) e[1];
		bot = (Expression<String>) e[2];
		return true;
	}
	
	@Override
	public String toString(Event paramEvent, boolean paramBoolean) {
		return syntax;
	}
	
	@Override
	protected void execute(Event e) {
		Plugin plugin = Bukkit.getPluginManager().getPlugin("PurpleIRC"); 
		PurpleIRC pirc = (PurpleIRC) plugin;
		String b = bot.getSingle(e);
		String c = channel.getSingle(e);
		String r = "";
		if (reason != null) { 
			r = reason.getSingle(e);
		}
		if (!c.contains("#")) {
			c = "#" + c;
		}
		if (pirc.ircBots.containsKey(b) && b != null && c != null && r != null) {
            if (pirc.ircBots.get(b).isConnected()) {
                for (Channel channel : pirc.ircBots.get(b).getChannels()) {
                    if (channel.getName().equalsIgnoreCase(c)) {
                        channel.send().part(r);
                        return;
                    }
                }
                Skript.error("Channel \"" + c + "\" is not valid");
            } else {
                Skript.error("Bot \"" + b + "\" is not connected");
            }
		} else {
			Skript.error("Bot \"" + b + "\" not found or arguments null");
		}
	}

	static {
		Skript.registerEffect(EffLeave.class, syntax);
	}
}