/*
 * Decompiled with CFR 0.152.
 */
package mc.hentrax.piratesk.worldedit;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.util.regex.Matcher;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffSaveSchematic
extends Effect {
    private Expression<Location> loc1;
    private Expression<Location> loc2;
    private Expression<String> name;

    protected void execute(Event e) {
        String name = (String)this.name.getSingle(e);
        Location loc1 = (Location)this.loc1.getSingle(e);
        Location loc2 = (Location)this.loc2.getSingle(e);
        name = name.endsWith(".schematic") ? name : String.valueOf(name) + ".schematic";
        File file = name.startsWith("/") ? new File(name.replaceFirst("/", "").replaceAll("/", Matcher.quoteReplacement(File.separator))) : new File(("plugins/WorldEdit/" + WorldEdit.getInstance().getConfiguration().saveDir + "/" + name).replaceAll("/", Matcher.quoteReplacement(File.separator)));
        Vector v1 = BukkitUtil.toVector((Location)loc1);
        Vector v2 = BukkitUtil.toVector((Location)loc2);
        CuboidRegion rg = new CuboidRegion(v1, v2);
        EditSession es = WorldEdit.getInstance().getEditSessionFactory().getEditSession((LocalWorld)new BukkitWorld(loc1.getWorld()), -1);
        CuboidClipboard cc = new CuboidClipboard(rg.getMaximumPoint().subtract(rg.getMinimumPoint()).add(new Vector(1, 1, 1)), rg.getMinimumPoint());
        cc.copy(es);
        try {
            SchematicFormat.MCEDIT.save(cc, file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString(Event e, boolean b) {
        return "save blocks between two locations to schematic";
    }

    public boolean init(Expression<?>[] e, int i, Kleenean k, SkriptParser.ParseResult p) {
        this.loc1 = e[0];
        this.loc2 = e[1];
        this.name = e[2];
        return true;
    }
}

