/*
 * Decompiled with CFR 0.152.
 */
package net.grota.piratesk.worldedit;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.schematic.SchematicFormat;
import com.sk89q.worldedit.util.Countable;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprBlocksWithinSchematic
extends SimpleExpression<Block> {
    private Expression<String> path;

    public String toString(Event event, boolean b) {
        return "blocks within schematic";
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    protected Block[] get(Event e) {
        String path = (String)this.path.getSingle(e);
        path = path.endsWith(".schematic") ? path : path + ".schematic";
        File file = path.startsWith("/") ? new File(path.replaceFirst("/", "").replaceAll("/", Matcher.quoteReplacement(File.separator))) : new File(("plugins/WorldEdit/" + WorldEdit.getInstance().getConfiguration().saveDir + "/" + path).replaceAll("/", Matcher.quoteReplacement(File.separator)));
        if (!file.exists()) {
            Skript.error((String)("Schematic \"" + file.toString() + "\" does not exist."));
            return null;
        }
        List blocks = null;
        try {
            blocks = SchematicFormat.getFormat((File)file).load(file).getBlockDistributionWithData();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        List list = null;
        for (Countable block : blocks) {
            Block b = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0).getBlock();
            b.setType(Material.getMaterial((int)((BaseBlock)block.getID()).getType()));
            list.add(b);
        }
        return list.toArray(new Block[0]);
    }

    public boolean init(Expression<?>[] e, int i, Kleenean k, SkriptParser.ParseResult p) {
        this.path = e[0];
        return true;
    }
}

