/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.npcaddon.util.npcs;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import java.util.UUID;
import java.util.logging.Level;
import me.limeglass.npcaddon.util.Utils;
import org.bukkit.Bukkit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ProfileLoader {
    private final String uuid;
    private final String name;
    private final String skinOwner;

    public ProfileLoader(String uuid, String name) {
        this(uuid, name, name);
    }

    public ProfileLoader(String uuid, String name, String skinOwner) {
        this.uuid = uuid == null ? null : uuid.replaceAll("-", "");
        this.name = Utils.cc(name);
        this.skinOwner = skinOwner;
    }

    public GameProfile loadProfile() {
        UUID id = this.uuid == null ? this.parseUUID(this.getUUID(this.name)) : this.parseUUID(this.uuid);
        GameProfile profile = new GameProfile(id, this.name);
        this.addProperties(profile);
        return profile;
    }

    private void addProperties(GameProfile profile) {
        String uuid = this.getUUID(this.skinOwner);
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            URLConnection uc = url.openConnection();
            uc.setUseCaches(false);
            uc.setDefaultUseCaches(false);
            uc.addRequestProperty("User-Agent", "Mozilla/5.0");
            uc.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            uc.addRequestProperty("Pragma", "no-cache");
            String json = new Scanner(uc.getInputStream(), "UTF-8").useDelimiter("\\A").next();
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(json);
            JSONArray properties = (JSONArray)((JSONObject)obj).get((Object)"properties");
            int i = 0;
            while (i < properties.size()) {
                try {
                    String signature;
                    JSONObject property = (JSONObject)properties.get(i);
                    String name = (String)property.get((Object)"name");
                    String value = (String)property.get((Object)"value");
                    String string = signature = property.containsKey((Object)"signature") ? (String)property.get((Object)"signature") : null;
                    if (signature != null) {
                        profile.getProperties().put((Object)name, (Object)new Property(name, value, signature));
                    } else {
                        profile.getProperties().put((Object)name, (Object)new Property(value, name));
                    }
                }
                catch (Exception e) {
                    Bukkit.getLogger().log(Level.WARNING, "Failed to apply auth property", e);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getUUID(String name) {
        return Bukkit.getOfflinePlayer((String)name).getUniqueId().toString().replaceAll("-", "");
    }

    private UUID parseUUID(String uuidStr) {
        String[] uuidComponents = new String[]{uuidStr.substring(0, 8), uuidStr.substring(8, 12), uuidStr.substring(12, 16), uuidStr.substring(16, 20), uuidStr.substring(20, uuidStr.length())};
        StringBuilder builder = new StringBuilder();
        String[] stringArray = uuidComponents;
        int n = uuidComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            builder.append(component).append('-');
            ++n2;
        }
        builder.setLength(builder.length() - 1);
        return UUID.fromString(builder.toString());
    }
}

