/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.npcaddon.util;

import java.io.File;
import java.io.IOException;
import me.limeglass.npcaddon.NpcAddon;
import me.limeglass.npcaddon.util.npcs.Npc;
import me.limeglass.npcaddon.util.npcs.NpcManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlSaver {
    private static File file = new File(NpcAddon.getInstance().getDataFolder(), "Npcs.yml");
    private static YamlConfiguration Yaml = new YamlConfiguration();

    public static void saveNPCs() {
        try {
            if (!NpcAddon.getInstance().getDataFolder().exists()) {
                NpcAddon.getInstance().getDataFolder().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            Yaml.load(file);
            for (Npc npc : NpcManager.npcs.values()) {
                Yaml.set(String.valueOf(npc.getName()) + ".Skin", (Object)npc.getSkinName());
                Yaml.set(String.valueOf(npc.getName()) + ".Location.World", (Object)npc.getLocation().getWorld().getName());
                Yaml.set(String.valueOf(npc.getName()) + ".Location.X", (Object)npc.getLocation().getX());
                Yaml.set(String.valueOf(npc.getName()) + ".Location.Y", (Object)npc.getLocation().getY());
                Yaml.set(String.valueOf(npc.getName()) + ".Location.Z", (Object)npc.getLocation().getZ());
                Yaml.set(String.valueOf(npc.getName()) + ".Location.Yaw", (Object)Float.valueOf(npc.getLocation().getYaw()));
                Yaml.set(String.valueOf(npc.getName()) + ".Location.Pitch", (Object)Float.valueOf(npc.getLocation().getPitch()));
            }
            Yaml.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static void loadNpcs() {
        try {
            if (!NpcAddon.getInstance().getDataFolder().exists()) {
                NpcAddon.getInstance().getDataFolder().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            Yaml.load(file);
            for (String t : Yaml.getKeys(false)) {
                String skin = Yaml.getString(String.valueOf(t) + ".Skin");
                String world = Yaml.getString(String.valueOf(t) + ".Location.World");
                Double x = Yaml.getDouble(String.valueOf(t) + ".Location.X");
                Double y = Yaml.getDouble(String.valueOf(t) + ".Location.Y");
                Double z = Yaml.getDouble(String.valueOf(t) + ".Location.Z");
                Float yaw = Float.valueOf((float)Yaml.getDouble(String.valueOf(t) + ".Location.Yaw"));
                Float pitch = Float.valueOf((float)Yaml.getDouble(String.valueOf(t) + ".Location.Pitch"));
                Location location = new Location(Bukkit.getServer().getWorld(world), x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
                NpcManager.registerNpc(skin, location);
                Yaml.set(t, null);
            }
            Yaml.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

